/*
 * Decompiled with CFR 0.152.
 */
package org.bn.utils;

import java.io.IOException;
import java.io.InputStream;

public class BitArrayInputStream
extends InputStream {
    private final InputStream byteStream;
    private int currentBit = 0;
    private int currentByte;

    public BitArrayInputStream(InputStream byteStream) {
        this.byteStream = byteStream;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.currentBit == 0) {
            return this.byteStream.read();
        }
        int nextByte = this.byteStream.read();
        int result = (this.currentByte << this.currentBit | nextByte >> 8 - this.currentBit) & 0xFF;
        this.currentByte = nextByte;
        return result;
    }

    public synchronized int readBit() throws IOException {
        if (this.currentBit == 0) {
            this.currentByte = this.byteStream.read();
        }
        ++this.currentBit;
        int result = this.currentByte >> 8 - this.currentBit & 1;
        if (this.currentBit > 7) {
            this.currentBit = 0;
        }
        return result;
    }

    public synchronized int readBits(int nBits) throws IOException {
        int result = 0;
        for (int i = 0; i < nBits && i <= 32; ++i) {
            result = result << 1 | this.readBit();
        }
        return result;
    }

    public void skipUnreadedBits() {
        this.currentBit = 0;
    }
}

