/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.gateway;

import fi.iki.elonen.NanoHTTPD;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;
import net.heberling.ismart.gateway.GetData;

public class App
extends NanoHTTPD {
    public long cooldownAccessTime;
    public int cooldownSeconds = 600;
    public String cachedApiResponse;

    public App() throws IOException {
        super(42042);
        this.start(5000, false);
        System.out.println("\nSAIC-API Gateway running! Access the API endpoints via http://localhost:42042/ \n");
    }

    public static void main(String[] args) {
        try {
            new App();
        }
        catch (IOException ioe) {
            System.err.println("Couldn't start server:\n" + ioe);
        }
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        Object msg = "";
        HashMap content = new HashMap();
        NanoHTTPD.Method method = session.getMethod();
        if (NanoHTTPD.Method.PUT.equals((Object)method) || NanoHTTPD.Method.POST.equals((Object)method)) {
            try {
                session.parseBody(content);
            }
            catch (IOException ioe) {
                System.out.println("unable to parse body of request");
            }
            catch (NanoHTTPD.ResponseException re) {
                System.out.println("unable to parse body of request");
            }
        }
        if (session.getUri().equals("/getData")) {
            System.out.println("Accessed: /getData");
            String user = (String)session.getParms().get("user");
            String password = (String)session.getParms().get("password");
            String skipCooldown = (String)session.getParms().get("skipCooldown");
            if (user != null && password != null) {
                String[] loginData = new String[]{user, password};
                if (Objects.equals(skipCooldown, "true")) {
                    System.out.println("Cooldown was skipped via post-parameter 'skipCooldown'");
                    this.cooldownAccessTime = 0L;
                }
                if (Instant.now().getEpochSecond() - this.cooldownAccessTime >= (long)this.cooldownSeconds) {
                    System.out.println("Cooldown of " + this.cooldownSeconds + " seconds is over and API request will be sent.");
                    this.cooldownAccessTime = Instant.now().getEpochSecond();
                    try {
                        String[] jsonOutput = new String[4];
                        jsonOutput = GetData.startResponse(loginData);
                        this.cachedApiResponse = jsonOutput[3];
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    long secondsUntilNextRequest = Instant.now().getEpochSecond() - this.cooldownAccessTime - (long)this.cooldownSeconds;
                    secondsUntilNextRequest = Math.abs(secondsUntilNextRequest);
                    System.out.println("Cached output of vehicleResponse (implemented to reduce 12v battery drain). Cooldown seconds to next API request: " + secondsUntilNextRequest);
                }
                msg = (String)msg + this.cachedApiResponse;
            } else {
                System.out.println("No login post parameters set (user, password).");
                msg = (String)msg + "No login post parameters set (user, password).";
            }
        } else {
            msg = (String)msg + "API error";
        }
        return App.newFixedLengthResponse((String)msg);
    }
}

