/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.asn1;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import net.heberling.ismart.asn1.AbstractMessage;
import org.bn.coders.IASN1PreparedElement;

public class Anonymizer {
    public static void anonymize(AbstractMessage<?, ?, ?> message) {
        try {
            for (Field field : message.getClass().getDeclaredFields()) {
                if (!field.getName().equals("reserved")) continue;
                field.setAccessible(true);
                Arrays.fill((byte[])field.get(message), (byte)0);
            }
            Anonymizer.anonymize(message.getBody());
            if (message.getApplicationData() != null) {
                Anonymizer.anonymize(message.getApplicationData());
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void anonymize(IASN1PreparedElement element) throws IllegalAccessException {
        block26: for (Field field : element.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(element) == null) continue;
            if (IASN1PreparedElement.class.isAssignableFrom(field.getType())) {
                Anonymizer.anonymize((IASN1PreparedElement)field.get(element));
                continue;
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection c = (Collection)field.get(element);
                for (Object o : c) {
                    if (!(o instanceof IASN1PreparedElement)) continue;
                    Anonymizer.anonymize((IASN1PreparedElement)o);
                }
                continue;
            }
            switch (field.getName()) {
                case "password": {
                    field.set(element, ((String)field.get(element)).replaceAll(".", "*"));
                    continue block26;
                }
                case "email": 
                case "uid": 
                case "pin": 
                case "token": 
                case "refreshToken": 
                case "vin": {
                    field.set(element, Anonymizer.anonymizeString((String)field.get(element)));
                    continue block26;
                }
                case "deviceId": {
                    String[] s = ((String)field.get(element)).split("###");
                    field.set(element, Anonymizer.anonymizeString(s[0]) + "###" + s[1]);
                    continue block26;
                }
                case "seconds": 
                case "bindTime": 
                case "eventCreationTime": 
                case "latitude": 
                case "longitude": {
                    if (field.get(element) instanceof Long) {
                        field.set(element, (Long)field.get(element) / 100000L * 100000L);
                        continue block26;
                    }
                    field.set(element, (Integer)field.get(element) / 100000 * 100000);
                    continue block26;
                }
                case "eventID": 
                case "lastKeySeen": {
                    field.set(element, 9999);
                    continue block26;
                }
                case "content": {
                    field.set(element, new String((byte[])field.get(element), StandardCharsets.UTF_8).replaceAll("\\(\\*\\*\\*...\\)", "(***XXX)").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    private static String anonymizeString(String s) {
        return s.replaceAll("[a-zA-Z]", "X").replaceAll("[1-9]", "9");
    }
}

