/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.javadatetime;

import com.owlike.genson.ext.javadatetime.BaseTemporalAccessorConverter;
import com.owlike.genson.ext.javadatetime.DateTimeConverterOptions;
import com.owlike.genson.ext.javadatetime.DateTimeUtil;
import com.owlike.genson.ext.javadatetime.TimestampHandler;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.LinkedHashMap;

class InstantConverter
extends BaseTemporalAccessorConverter<Instant> {
    InstantConverter(DateTimeConverterOptions options) {
        super(options, new InstantTimestampHandler(options), Instant::from);
    }

    private static class InstantTimestampHandler
    extends TimestampHandler<Instant> {
        private static final LinkedHashMap<String, TemporalField> INSTANT_TEMPORAL_FIELDS = new LinkedHashMap();

        private InstantTimestampHandler(DateTimeConverterOptions options) {
            super(DateTimeUtil::instantToMillis, DateTimeUtil::instantFromMillis, DateTimeUtil::instantToNanos, DateTimeUtil::instantFromNanos, INSTANT_TEMPORAL_FIELDS, Instant::now);
        }

        static {
            INSTANT_TEMPORAL_FIELDS.put("second", ChronoField.INSTANT_SECONDS);
            INSTANT_TEMPORAL_FIELDS.put("nano", ChronoField.NANO_OF_SECOND);
        }
    }
}

