/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.javadatetime;

import com.owlike.genson.ext.javadatetime.BaseTemporalAccessorConverter;
import com.owlike.genson.ext.javadatetime.DateTimeConverterOptions;
import com.owlike.genson.ext.javadatetime.TimestampHandler;
import java.time.YearMonth;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.util.LinkedHashMap;

class YearMonthConverter
extends BaseTemporalAccessorConverter<YearMonth> {
    private static final YearMonth EPOCH_YEAR_MONTH = YearMonth.of(1970, 1);

    YearMonthConverter(DateTimeConverterOptions options) {
        super(options, new YearMonthTimestampHandler(options), YearMonth::from);
    }

    private static long getEpochMonth(YearMonth yearMonth) {
        return EPOCH_YEAR_MONTH.until(yearMonth, ChronoUnit.MONTHS);
    }

    private static YearMonth fromEpochMonth(long months) {
        return EPOCH_YEAR_MONTH.plus(months, ChronoUnit.MONTHS);
    }

    private static class YearMonthTimestampHandler
    extends TimestampHandler<YearMonth> {
        private static final LinkedHashMap<String, TemporalField> YEAR_MONTH_TEMPORAL_FIELDS = new LinkedHashMap();

        private YearMonthTimestampHandler(DateTimeConverterOptions options) {
            super(x$0 -> YearMonthConverter.getEpochMonth(x$0), x$0 -> YearMonthConverter.fromEpochMonth(x$0), x$0 -> YearMonthConverter.getEpochMonth(x$0), x$0 -> YearMonthConverter.fromEpochMonth(x$0), YEAR_MONTH_TEMPORAL_FIELDS, YearMonth::now);
        }

        static {
            YEAR_MONTH_TEMPORAL_FIELDS.put("year", ChronoField.YEAR);
            YEAR_MONTH_TEMPORAL_FIELDS.put("month", ChronoField.MONTH_OF_YEAR);
        }
    }
}

