/*
 * Decompiled with CFR 0.152.
 */
package org.bn.metadata;

import java.io.InputStream;
import java.io.OutputStream;
import org.bn.annotations.ASN1Element;
import org.bn.coders.DecodedObject;
import org.bn.coders.ElementInfo;
import org.bn.coders.IASN1TypesDecoder;
import org.bn.coders.IASN1TypesEncoder;
import org.bn.metadata.ASN1FieldMetadata;

public class ASN1ElementMetadata
extends ASN1FieldMetadata {
    private boolean isOptional = true;
    private boolean hasTag = false;
    private boolean isImplicitTag = false;
    private int tagClass = 128;
    private int tag = 0;
    private boolean hasDefaultValue = false;

    public ASN1ElementMetadata(ASN1Element annotation) {
        this(annotation.name(), annotation.isOptional(), annotation.hasTag(), annotation.isImplicitTag(), annotation.tagClass(), annotation.tag(), annotation.hasDefaultValue());
    }

    public ASN1ElementMetadata(String name, boolean isOptional, boolean hasTag, boolean isImplicitTag, int tagClass, int tag, boolean hasDefaultValue) {
        super(name);
        this.isOptional = isOptional;
        this.hasTag = hasTag;
        this.isImplicitTag = isImplicitTag;
        this.tagClass = tagClass;
        this.tag = tag;
        this.hasDefaultValue = hasDefaultValue;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean hasTag() {
        return this.hasTag;
    }

    public boolean isImplicitTag() {
        return this.isImplicitTag;
    }

    public int getTagClass() {
        return this.tagClass;
    }

    public int getTag() {
        return this.tag;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    @Override
    public int encode(IASN1TypesEncoder encoder, Object object, OutputStream stream, ElementInfo elementInfo) throws Exception {
        return encoder.encodePreparedElement(object, stream, elementInfo);
    }

    @Override
    public DecodedObject<?> decode(IASN1TypesDecoder decoder, DecodedObject<Integer> decodedTag, Class<?> objectClass, ElementInfo elementInfo, InputStream stream) throws Exception {
        elementInfo.setPreparedInstance(null);
        return decoder.decodeElement(decodedTag, objectClass, elementInfo, stream);
    }
}

