/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.mqtt;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherBody;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherHeader;
import net.heberling.ismart.asn1.v1_1.Message;
import net.heberling.ismart.asn1.v1_1.MessageCoder;
import net.heberling.ismart.asn1.v1_1.MessageCounter;
import net.heberling.ismart.asn1.v1_1.entity.MessageListReq;
import net.heberling.ismart.asn1.v1_1.entity.MessageListResp;
import net.heberling.ismart.asn1.v1_1.entity.StartEndNumber;
import net.heberling.ismart.mqtt.SaicMessage;
import net.heberling.ismart.mqtt.SaicMqttGateway;
import org.bn.coders.IASN1PreparedElement;
import org.eclipse.paho.client.mqttv3.MqttException;

class MessageHandler
implements Runnable {
    private final String uid;
    private final String token;
    private final SaicMqttGateway gateway;

    public MessageHandler(String uid, String token, SaicMqttGateway gateway) {
        this.uid = uid;
        this.token = token;
        this.gateway = gateway;
    }

    @Override
    public void run() {
        Message messageListRequestMessage = new Message(new MP_DispatcherHeader(), new MP_DispatcherBody(), (IASN1PreparedElement)new MessageListReq());
        ((MP_DispatcherHeader)messageListRequestMessage.getHeader()).setProtocolVersion(Integer.valueOf(18));
        MessageCounter messageCounter = new MessageCounter();
        messageCounter.setDownlinkCounter(Integer.valueOf(0));
        messageCounter.setUplinkCounter(Integer.valueOf(1));
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setMessageCounter(messageCounter);
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setMessageID(Integer.valueOf(1));
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setIccID("12345678901234567890");
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setSimInfo("1234567890987654321");
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setEventCreationTime(Long.valueOf(Instant.now().getEpochSecond()));
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setApplicationID("531");
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setApplicationDataProtocolVersion(Integer.valueOf(513));
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setTestFlag(Integer.valueOf(2));
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setUid(this.uid);
        ((MP_DispatcherBody)messageListRequestMessage.getBody()).setToken(this.token);
        ((MessageListReq)messageListRequestMessage.getApplicationData()).setStartEndNumber(new StartEndNumber());
        ((MessageListReq)messageListRequestMessage.getApplicationData()).getStartEndNumber().setStartNumber(Long.valueOf(1L));
        ((MessageListReq)messageListRequestMessage.getApplicationData()).getStartEndNumber().setEndNumber(Long.valueOf(5L));
        ((MessageListReq)messageListRequestMessage.getApplicationData()).setMessageGroup("ALARM");
        String messageListRequest = new MessageCoder(MessageListReq.class).encodeRequest(messageListRequestMessage);
        try {
            String messageListResponse = SaicMqttGateway.sendRequest(messageListRequest, "https://tap-eu.soimt.com/TAP.Web/ota.mp");
            Message messageListResponseMessage = new MessageCoder(MessageListResp.class).decodeResponse(messageListResponse);
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new MessageCoder(MessageListResp.class), messageListResponseMessage)));
            if (messageListResponseMessage.getApplicationData() != null) {
                for (net.heberling.ismart.asn1.v1_1.entity.Message message : ((MessageListResp)messageListResponseMessage.getApplicationData()).getMessages()) {
                    this.gateway.notifyMessage(this.convert(message));
                }
            }
        }
        catch (IOException | MqttException e) {
            throw new RuntimeException(e);
        }
    }

    private SaicMessage convert(net.heberling.ismart.asn1.v1_1.entity.Message message) {
        return new SaicMessage(message.getMessageId(), message.getMessageType(), new String(message.getTitle(), StandardCharsets.UTF_8), ZonedDateTime.ofInstant(Instant.ofEpochSecond(message.getMessageTime().getSeconds()), ZoneId.systemDefault()), new String(message.getSender(), StandardCharsets.UTF_8), new String(message.getContent(), StandardCharsets.UTF_8), message.getReadStatus(), message.getVin());
    }
}

