/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.mqtt;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.ext.GensonBundle;
import com.owlike.genson.ext.javadatetime.JavaDateTimeBundle;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.heberling.ismart.asn1.AbstractMessage;
import net.heberling.ismart.asn1.AbstractMessageCoder;
import net.heberling.ismart.asn1.Anonymizer;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherBody;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherHeader;
import net.heberling.ismart.asn1.v1_1.Message;
import net.heberling.ismart.asn1.v1_1.MessageCoder;
import net.heberling.ismart.asn1.v1_1.MessageCounter;
import net.heberling.ismart.asn1.v1_1.entity.MP_UserLoggingInReq;
import net.heberling.ismart.asn1.v1_1.entity.MP_UserLoggingInResp;
import net.heberling.ismart.asn1.v1_1.entity.VinInfo;
import net.heberling.ismart.cli.UTF8StringObjectWriter;
import net.heberling.ismart.mqtt.MessageHandler;
import net.heberling.ismart.mqtt.SaicMessage;
import net.heberling.ismart.mqtt.VehicleHandler;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.bn.annotations.ASN1Enum;
import org.bn.annotations.ASN1Sequence;
import org.bn.coders.IASN1PreparedElement;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import picocli.CommandLine;

@CommandLine.Command(name="ismart-mqtt-gateway", mixinStandardHelpOptions=true)
public class SaicMqttGateway
implements Callable<Integer> {
    @CommandLine.Option(names={"-m", "--mqtt-uri"}, required=true, description={"The URI to the MQTT Server.", "Environment Variable: MQTT_URI"}, defaultValue="${env:MQTT_URI}")
    private String mqttUri;
    @CommandLine.Option(names={"--mqtt-user"}, description={"The MQTT user name.", "Environment Variable: MQTT_USER"}, defaultValue="${env:MQTT_USER}")
    private String mqttUser;
    @CommandLine.Option(names={"--mqtt-password"}, description={"The MQTT password.", "Environment Variable: MQTT_PASSWORD"}, defaultValue="${env:MQTT_PASSWORD}")
    private char[] mqttPassword;
    @CommandLine.Option(names={"-u", "--saic-user"}, required=true, description={"The SAIC user name.", "Environment Variable: SAIC_USER"}, defaultValue="${env:SAIC_USER}")
    private String saicUser;
    @CommandLine.Option(names={"-p", "--saic-password"}, required=true, description={"The SAIC password.", "Environment Variable: SAIC_PASSWORD"}, defaultValue="${env:SAIC_PASSWORD}")
    private String saicPassword;
    @CommandLine.Option(names={"--abrp-api-key"}, description={"The API key for the A Better Route Planer telemetry API.", "Default is the open source telemetry API key 8cfc314b-03cd-4efe-ab7d-4431cd8f2e2d", "Environment Variable: ABRP_API_KEY"}, defaultValue="${env:ABRP_API_KEY:-8cfc314b-03cd-4efe-ab7d-4431cd8f2e2d}")
    private String abrpApiKey;
    @CommandLine.Option(names={"--abrp-user-token"}, description={"The mapping of VIN to ABRP User Token.", "Multiple mappings can be provided seperated by ,", "Example: LSJXXXX=12345-abcdef,LSJYYYY=67890-ghijkl", "Environment Variable: ABRP_USER_TOKEN"}, defaultValue="${env:ABRP_USER_TOKEN}", split=",")
    private Map<String, String> vinAbrpTokenMap = new HashMap<String, String>();
    private IMqttClient client;
    private final Map<String, VehicleHandler> vehicleHandlerMap = new HashMap<String, VehicleHandler>();

    @Override
    public Integer call() throws Exception {
        String publisherId = UUID.randomUUID().toString();
        try (MqttClient client = new MqttClient(this.mqttUri, publisherId, null){

            public void close() throws MqttException {
                this.disconnect();
                super.close(true);
            }
        };){
            this.client = client;
            MqttConnectOptions options = new MqttConnectOptions();
            options.setAutomaticReconnect(true);
            options.setCleanSession(true);
            options.setConnectionTimeout(10);
            if (this.mqttUser != null) {
                options.setUserName(this.mqttUser);
            }
            if (this.mqttPassword != null) {
                options.setPassword(this.mqttPassword);
            }
            client.connect(options);
            Message loginRequestMessage = new Message(new MP_DispatcherHeader(), new MP_DispatcherBody(), (IASN1PreparedElement)new MP_UserLoggingInReq());
            MessageCounter messageCounter = new MessageCounter();
            messageCounter.setDownlinkCounter(Integer.valueOf(0));
            messageCounter.setUplinkCounter(Integer.valueOf(1));
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setMessageCounter(messageCounter);
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setMessageID(Integer.valueOf(1));
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setIccID("12345678901234567890");
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setSimInfo("1234567890987654321");
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setEventCreationTime(Long.valueOf(Instant.now().getEpochSecond()));
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setApplicationID("501");
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setApplicationDataProtocolVersion(Integer.valueOf(513));
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setTestFlag(Integer.valueOf(2));
            ((MP_DispatcherBody)loginRequestMessage.getBody()).setUid("0000000000000000000000000000000000000000000000000#".substring(this.saicUser.length()) + this.saicUser);
            ((MP_UserLoggingInReq)loginRequestMessage.getApplicationData()).setPassword(this.saicPassword);
            String loginRequest = new MessageCoder(MP_UserLoggingInReq.class).encodeRequest(loginRequestMessage);
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new MessageCoder(MP_UserLoggingInReq.class), loginRequestMessage)));
            String loginResponse = SaicMqttGateway.sendRequest(loginRequest, "https://tap-eu.soimt.com/TAP.Web/ota.mp");
            Message loginResponseMessage = new MessageCoder(MP_UserLoggingInResp.class).decodeResponse(loginResponse);
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new MessageCoder(MP_UserLoggingInResp.class), loginResponseMessage)));
            List futures = ((MP_UserLoggingInResp)loginResponseMessage.getApplicationData()).getVinList().stream().map(arg_0 -> this.lambda$call$0((IMqttClient)client, loginResponseMessage, arg_0)).map(handler -> () -> {
                handler.handleVehicle();
                return null;
            }).map(Executors.newSingleThreadExecutor()::submit).collect(Collectors.toList());
            ScheduledFuture<?> pollingJob = this.createMessagePoller(((MP_DispatcherBody)loginResponseMessage.getBody()).getUid(), ((MP_UserLoggingInResp)loginResponseMessage.getApplicationData()).getToken());
            futures.add(pollingJob);
            for (Future future : futures) {
                future.get();
            }
            Integer n = 0;
            return n;
        }
    }

    private ScheduledFuture<?> createMessagePoller(String uid, String token) {
        return Executors.newSingleThreadScheduledExecutor().scheduleWithFixedDelay(new MessageHandler(uid, token, this), 1L, 1L, TimeUnit.SECONDS);
    }

    public static void main(String ... args) {
        int exitCode = new CommandLine((Object)new SaicMqttGateway()).execute(args);
        System.exit(exitCode);
    }

    static <H extends IASN1PreparedElement, B extends IASN1PreparedElement, E extends IASN1PreparedElement, M extends AbstractMessage<H, B, E>> M anonymized(AbstractMessageCoder<H, B, E, M> coder, M message) {
        AbstractMessage messageCopy = coder.decodeResponse(coder.encodeRequest(message));
        Anonymizer.anonymize((AbstractMessage)messageCopy);
        return (M)messageCopy;
    }

    public static void fillReserved(byte[] reservedBytes) {
        System.arraycopy((ThreadLocalRandom.current().nextLong() + "1111111111111111").getBytes(), 0, reservedBytes, 0, 16);
    }

    static String sendRequest(String request, String endpoint) throws IOException {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpPost httppost = new HttpPost(endpoint);
            httppost.setEntity((HttpEntity)new StringEntity(request, ContentType.TEXT_HTML));
            HttpClientResponseHandler responseHandler = response -> {
                int status = response.getCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    try {
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    catch (ParseException ex) {
                        throw new ClientProtocolException((Throwable)ex);
                    }
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            };
            String string = (String)httpclient.execute((ClassicHttpRequest)httppost, responseHandler);
            return string;
        }
    }

    public static String toJSON(Object message) {
        ChainedFactory chain = new ChainedFactory(){

            protected Converter<?> create(Type type, Genson genson, final Converter<?> nextConverter) {
                return new Converter<Object>(){

                    public void serialize(Object object, ObjectWriter writer, Context ctx) throws Exception {
                        if (object != null) {
                            writer.beginNextObjectMetadata();
                            if (object.getClass().isAnnotationPresent(ASN1Enum.class)) {
                                writer.writeMetadata("ASN1Type", object.getClass().getAnnotation(ASN1Enum.class).name());
                            } else if (object.getClass().isAnnotationPresent(ASN1Sequence.class)) {
                                writer.writeMetadata("ASN1Type", object.getClass().getAnnotation(ASN1Sequence.class).name());
                            }
                        }
                        Converter n = nextConverter;
                        if (!(writer instanceof UTF8StringObjectWriter)) {
                            writer = new UTF8StringObjectWriter(writer);
                        }
                        n.serialize(object, writer, ctx);
                    }

                    public Object deserialize(ObjectReader reader, Context ctx) throws Exception {
                        return nextConverter.deserialize(reader, ctx);
                    }
                };
            }
        };
        chain.withNext((Factory)new ChainedFactory(){

            protected Converter<?> create(Type type, Genson genson, Converter<?> converter) {
                final Class clazz = TypeUtil.getRawClass((Type)type);
                if (clazz.isAnnotationPresent(ASN1Enum.class)) {
                    return new Converter<Object>(){

                        public void serialize(Object o, ObjectWriter objectWriter, Context context) throws Exception {
                            Method getValue = clazz.getMethod("getValue", new Class[0]);
                            Object value = getValue.invoke(o, new Object[0]);
                            if (value == null) {
                                objectWriter.writeNull();
                            } else {
                                objectWriter.writeString(String.valueOf(value));
                            }
                        }

                        public Object deserialize(ObjectReader objectReader, Context context) {
                            throw new UnsupportedOperationException("not implemented yet");
                        }
                    };
                }
                return converter;
            }
        });
        return new GensonBuilder().useDateAsTimestamp(false).withBundle(new GensonBundle[]{new JavaDateTimeBundle()}).useIndentation(true).useRuntimeType(true).exclude("preparedData").withConverterFactory(chain).create().serialize(message);
    }

    public String getAbrpApiKey() {
        return this.abrpApiKey;
    }

    public String getAbrpUserToken(String vin) {
        return this.vinAbrpTokenMap.get(vin);
    }

    public void notifyMessage(SaicMessage message) throws MqttException {
        MqttMessage msg = new MqttMessage(SaicMqttGateway.toJSON(message).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(false);
        this.client.publish("saic/message/" + message.getMessageId(), msg);
        if (message.getVin() != null) {
            this.vehicleHandlerMap.get(message.getVin()).notifyMessage(message);
        }
    }

    private /* synthetic */ VehicleHandler lambda$call$0(IMqttClient client, Message loginResponseMessage, VinInfo vin) {
        VehicleHandler handler = new VehicleHandler(this, client, ((MP_DispatcherBody)loginResponseMessage.getBody()).getUid(), ((MP_UserLoggingInResp)loginResponseMessage.getApplicationData()).getToken(), vin);
        this.vehicleHandlerMap.put(vin.getVin(), handler);
        return handler;
    }
}

