/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.javadatetime;

import com.owlike.genson.ext.javadatetime.DateTimeUtil;
import com.owlike.genson.ext.javadatetime.TimestampFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

class DateTimeConverterOptions {
    private final DateTimeFormatter dateTimeFormatter;
    private final boolean asTimestamp;
    private final TimestampFormat timestampFormat;
    private final ZoneId zoneId;

    DateTimeConverterOptions(Class<?> clazz, DateTimeFormatter dateTimeFormatter, boolean asTimestamp, TimestampFormat timestampFormat, ZoneId zoneId) {
        this.dateTimeFormatter = dateTimeFormatter == null ? null : DateTimeUtil.createFormatterWithDefaults(dateTimeFormatter, zoneId);
        this.asTimestamp = asTimestamp;
        this.timestampFormat = timestampFormat;
        this.zoneId = clazz == Instant.class ? ZoneId.of("UTC") : zoneId;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public boolean isAsTimestamp() {
        return this.asTimestamp;
    }

    public TimestampFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }
}

