/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.javadatetime;

import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.GensonBuilder;
import com.owlike.genson.annotation.JsonDateFormat;
import com.owlike.genson.convert.ContextualFactory;
import com.owlike.genson.ext.GensonBundle;
import com.owlike.genson.ext.javadatetime.DateTimeConverterOptions;
import com.owlike.genson.ext.javadatetime.InstantConverter;
import com.owlike.genson.ext.javadatetime.LocalDateConverter;
import com.owlike.genson.ext.javadatetime.LocalDateTimeConverter;
import com.owlike.genson.ext.javadatetime.LocalTimeConverter;
import com.owlike.genson.ext.javadatetime.MonthDayConverter;
import com.owlike.genson.ext.javadatetime.OffsetDateTimeConverter;
import com.owlike.genson.ext.javadatetime.OffsetTimeConverter;
import com.owlike.genson.ext.javadatetime.TemporalAmountConverter;
import com.owlike.genson.ext.javadatetime.TimestampFormat;
import com.owlike.genson.ext.javadatetime.YearConverter;
import com.owlike.genson.ext.javadatetime.YearMonthConverter;
import com.owlike.genson.ext.javadatetime.ZonedDateTimeConverter;
import com.owlike.genson.ext.javadatetime.annotation.JsonTimestampFormat;
import com.owlike.genson.ext.javadatetime.annotation.JsonZoneId;
import com.owlike.genson.reflect.BeanProperty;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public class JavaDateTimeBundle
extends GensonBundle {
    private ZoneId zoneId = ZoneId.systemDefault();
    private Map<Class<?>, ConverterGenerator> converterGenerators = new HashMap();
    private Map<Class<? extends TemporalAccessor>, TimestampFormat> temporalAccessorTimestampFormats;
    private Map<Class<? extends TemporalAmount>, TimestampFormat> temporalAmountTimestampFormats;
    private Map<Class<?>, DateTimeFormatter> formatters;

    public JavaDateTimeBundle() {
        this.registerConverterGenerator(Instant.class, InstantConverter::new);
        this.registerConverterGenerator(ZonedDateTime.class, ZonedDateTimeConverter::new);
        this.registerConverterGenerator(OffsetDateTime.class, OffsetDateTimeConverter::new);
        this.registerConverterGenerator(LocalDateTime.class, LocalDateTimeConverter::new);
        this.registerConverterGenerator(LocalDate.class, LocalDateConverter::new);
        this.registerConverterGenerator(LocalTime.class, LocalTimeConverter::new);
        this.registerConverterGenerator(Year.class, YearConverter::new);
        this.registerConverterGenerator(YearMonth.class, YearMonthConverter::new);
        this.registerConverterGenerator(MonthDay.class, MonthDayConverter::new);
        this.registerConverterGenerator(OffsetTime.class, OffsetTimeConverter::new);
        this.registerConverterGenerator(Period.class, TemporalAmountConverter::period);
        this.registerConverterGenerator(Duration.class, TemporalAmountConverter::duration);
        this.temporalAccessorTimestampFormats = new HashMap<Class<? extends TemporalAccessor>, TimestampFormat>();
        this.temporalAccessorTimestampFormats.put(Instant.class, TimestampFormat.MILLIS);
        this.temporalAccessorTimestampFormats.put(ZonedDateTime.class, TimestampFormat.MILLIS);
        this.temporalAccessorTimestampFormats.put(OffsetDateTime.class, TimestampFormat.MILLIS);
        this.temporalAccessorTimestampFormats.put(LocalDateTime.class, TimestampFormat.MILLIS);
        this.temporalAccessorTimestampFormats.put(LocalDate.class, TimestampFormat.MILLIS);
        this.temporalAccessorTimestampFormats.put(LocalTime.class, TimestampFormat.MILLIS);
        this.temporalAccessorTimestampFormats.put(Year.class, TimestampFormat.ARRAY);
        this.temporalAccessorTimestampFormats.put(YearMonth.class, TimestampFormat.ARRAY);
        this.temporalAccessorTimestampFormats.put(MonthDay.class, TimestampFormat.ARRAY);
        this.temporalAccessorTimestampFormats.put(OffsetTime.class, TimestampFormat.ARRAY);
        this.temporalAmountTimestampFormats = new HashMap<Class<? extends TemporalAmount>, TimestampFormat>();
        this.temporalAmountTimestampFormats.put(Period.class, TimestampFormat.ARRAY);
        this.temporalAmountTimestampFormats.put(Duration.class, TimestampFormat.ARRAY);
        this.formatters = new HashMap();
        this.formatters.put(Instant.class, DateTimeFormatter.ISO_INSTANT);
        this.formatters.put(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        this.formatters.put(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.formatters.put(LocalDateTime.class, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        this.formatters.put(LocalDate.class, DateTimeFormatter.ISO_LOCAL_DATE);
        this.formatters.put(LocalTime.class, DateTimeFormatter.ISO_LOCAL_TIME);
        this.formatters.put(OffsetTime.class, DateTimeFormatter.ISO_OFFSET_TIME);
        this.formatters.put(Year.class, DateTimeFormatter.ofPattern("uuuu"));
        this.formatters.put(YearMonth.class, DateTimeFormatter.ofPattern("uuuu-MM"));
        this.formatters.put(MonthDay.class, DateTimeFormatter.ofPattern("MM-dd"));
    }

    @Override
    public void configure(GensonBuilder builder) {
        boolean asTimestamp = builder.isDateAsTimestamp();
        builder.withContextualFactory(new JavaDateTimeContextualFactory(asTimestamp));
        for (Map.Entry<Class<?>, ConverterGenerator> converterGeneratorEntry : this.converterGenerators.entrySet()) {
            Class<?> clazz = converterGeneratorEntry.getKey();
            ConverterGenerator converterGenerator = converterGeneratorEntry.getValue();
            DateTimeFormatter formatter = this.formatters.get(clazz);
            DateTimeConverterOptions options = new DateTimeConverterOptions(clazz, formatter, asTimestamp, this.getDefaultTimestampFormat(clazz), this.zoneId);
            Converter converter = converterGenerator.createConverter(options);
            builder.withConverters(converter);
        }
    }

    private <T> void registerConverterGenerator(Class<T> clazz, Function<DateTimeConverterOptions, Converter<T>> converterGeneratorFunction) {
        ConverterGenerator<T> converterGenerator = new ConverterGenerator<T>(converterGeneratorFunction);
        this.converterGenerators.put(clazz, converterGenerator);
    }

    public JavaDateTimeBundle setFormatter(Class<? extends TemporalAccessor> clazz, DateTimeFormatter formatter) {
        this.formatters.put(clazz, formatter);
        return this;
    }

    public JavaDateTimeBundle setTemporalAccessorTimestampFormat(Class<? extends TemporalAccessor> clazz, TimestampFormat timestampFormat) {
        this.temporalAccessorTimestampFormats.put(clazz, timestampFormat);
        return this;
    }

    public JavaDateTimeBundle setTemporalAmountTimestampFormat(Class<? extends TemporalAmount> clazz, TimestampFormat timestampFormat) {
        this.temporalAmountTimestampFormats.put(clazz, timestampFormat);
        return this;
    }

    public JavaDateTimeBundle setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    private TimestampFormat getDefaultTimestampFormat(Class<?> clazz) {
        if (TemporalAmount.class.isAssignableFrom(clazz)) {
            return this.temporalAmountTimestampFormats.get(clazz);
        }
        return this.temporalAccessorTimestampFormats.get(clazz);
    }

    private class ConverterGenerator<T> {
        private Function<DateTimeConverterOptions, Converter<T>> converterGeneratorFunction;

        ConverterGenerator(Function<DateTimeConverterOptions, Converter<T>> converterGeneratorFunction) {
            this.converterGeneratorFunction = converterGeneratorFunction;
        }

        Converter<T> createConverter(DateTimeConverterOptions options) {
            return this.converterGeneratorFunction.apply(options);
        }
    }

    private class JavaDateTimeContextualFactory
    implements ContextualFactory {
        private boolean timestampByDefault;

        private JavaDateTimeContextualFactory(boolean timestampByDefault) {
            this.timestampByDefault = timestampByDefault;
        }

        public Converter create(BeanProperty property, Genson genson) {
            if (this.hasRelevantAnnotation(property)) {
                Class<?> rawClass = property.getRawClass();
                for (Map.Entry supportedType : JavaDateTimeBundle.this.converterGenerators.entrySet()) {
                    Class clazz = (Class)supportedType.getKey();
                    ConverterGenerator generator = (ConverterGenerator)supportedType.getValue();
                    if (!clazz.isAssignableFrom(rawClass)) continue;
                    DateTimeConverterOptions options = this.createOptions(property, clazz);
                    return generator.createConverter(options);
                }
            }
            return null;
        }

        private boolean hasRelevantAnnotation(BeanProperty property) {
            JsonDateFormat formatAnn = property.getAnnotation(JsonDateFormat.class);
            JsonZoneId zoneIdAnn = property.getAnnotation(JsonZoneId.class);
            JsonTimestampFormat timestampFormatAnn = property.getAnnotation(JsonTimestampFormat.class);
            return formatAnn != null || zoneIdAnn != null || timestampFormatAnn != null;
        }

        private DateTimeConverterOptions createOptions(BeanProperty property, Class<?> clazz) {
            JsonDateFormat jsonDateFormat = property.getAnnotation(JsonDateFormat.class);
            DateTimeFormatter formatter = this.getFormatter(jsonDateFormat, (DateTimeFormatter)JavaDateTimeBundle.this.formatters.get(clazz));
            boolean asTimestamp = jsonDateFormat == null ? this.timestampByDefault : jsonDateFormat.asTimeInMillis();
            ZoneId zoneId = this.getZoneId(property);
            TimestampFormat timestampFormat = this.getTimestampFormat(property, JavaDateTimeBundle.this.getDefaultTimestampFormat(clazz));
            return new DateTimeConverterOptions(clazz, formatter, asTimestamp, timestampFormat, zoneId);
        }

        private DateTimeFormatter getFormatter(JsonDateFormat ann, DateTimeFormatter defaultFormatter) {
            if (ann == null || ann.value().isEmpty()) {
                return defaultFormatter;
            }
            Locale locale = ann.lang().isEmpty() ? Locale.getDefault() : new Locale(ann.lang());
            return DateTimeFormatter.ofPattern(ann.value()).withLocale(locale);
        }

        private ZoneId getZoneId(BeanProperty property) {
            JsonZoneId ann = property.getAnnotation(JsonZoneId.class);
            return ann == null || ann.value().isEmpty() ? JavaDateTimeBundle.this.zoneId : ZoneId.of(ann.value());
        }

        private TimestampFormat getTimestampFormat(BeanProperty property, TimestampFormat defaultTimestampFormat) {
            JsonTimestampFormat ann = property.getAnnotation(JsonTimestampFormat.class);
            return ann == null ? defaultTimestampFormat : ann.value();
        }
    }
}

