/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.javadatetime;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.annotation.HandleBeanView;
import com.owlike.genson.annotation.HandleClassMetadata;
import com.owlike.genson.ext.javadatetime.DateTimeConverterOptions;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

@HandleClassMetadata
@HandleBeanView
abstract class TemporalAmountConverter<T extends TemporalAmount>
implements Converter<T> {
    private static final LinkedHashMap<String, Function<Period, Number>> PERIOD_FIELD_EXTRACTORS = new LinkedHashMap();
    private static final LinkedHashMap<String, BiFunction<Period, Number, Period>> PERIOD_FIELD_APPLICATORS;
    private static final LinkedHashMap<String, Function<Duration, Number>> DURATION_FIELD_EXTRACTORS;
    private static final LinkedHashMap<String, BiFunction<Duration, Number, Duration>> DURATION_FIELD_APPLICATORS;
    private DateTimeConverterOptions options;
    private Function<String, T> parseFunction;
    private Supplier<T> instanceProvider;
    private LinkedHashMap<String, Function<T, Number>> fieldExtractors;
    private LinkedHashMap<String, BiFunction<T, Number, T>> fieldApplicatiors;

    private TemporalAmountConverter(DateTimeConverterOptions options, Function<String, T> parseFunction, Supplier<T> instanceProvider, LinkedHashMap<String, Function<T, Number>> fieldExtractors, LinkedHashMap<String, BiFunction<T, Number, T>> fieldApplicatiors) {
        this.options = options;
        this.parseFunction = parseFunction;
        this.instanceProvider = instanceProvider;
        this.fieldExtractors = fieldExtractors;
        this.fieldApplicatiors = fieldApplicatiors;
    }

    static TemporalAmountConverter<Duration> duration(DateTimeConverterOptions options) {
        return new TemporalAmountConverter<Duration>(options, Duration::parse, () -> Duration.ZERO, DURATION_FIELD_EXTRACTORS, DURATION_FIELD_APPLICATORS){};
    }

    static TemporalAmountConverter<Period> period(DateTimeConverterOptions options) {
        return new TemporalAmountConverter<Period>(options, Period::parse, () -> Period.ZERO, PERIOD_FIELD_EXTRACTORS, PERIOD_FIELD_APPLICATORS){};
    }

    @Override
    public void serialize(T object, ObjectWriter writer, Context ctx) {
        block5: {
            block4: {
                if (!this.options.isAsTimestamp()) break block4;
                switch (this.options.getTimestampFormat()) {
                    case ARRAY: {
                        this.writeArray(object, writer);
                        break block5;
                    }
                    case OBJECT: {
                        this.writeObject(object, writer);
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported timestamp format");
                    }
                }
            }
            writer.writeValue(object.toString());
        }
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) {
        TemporalAmount obj;
        block5: {
            block4: {
                if (!this.options.isAsTimestamp()) break block4;
                switch (this.options.getTimestampFormat()) {
                    case ARRAY: {
                        obj = this.readArray(reader);
                        break block5;
                    }
                    case OBJECT: {
                        obj = this.readObject(reader);
                        break block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported timestamp format");
                    }
                }
            }
            obj = (TemporalAmount)this.parseFunction.apply(reader.valueAsString());
        }
        return (T)obj;
    }

    private void writeArray(T object, ObjectWriter writer) {
        writer.beginArray();
        for (Function<T, Number> fieldExtractor : this.fieldExtractors.values()) {
            writer.writeValue(fieldExtractor.apply(object));
        }
        writer.endArray();
    }

    private T readArray(ObjectReader reader) {
        TemporalAmount obj = (TemporalAmount)this.instanceProvider.get();
        reader.beginArray();
        for (BiFunction<TemporalAmount, Number, TemporalAmount> biFunction : this.fieldApplicatiors.values()) {
            reader.next();
            obj = (TemporalAmount)biFunction.apply(obj, reader.valueAsLong());
        }
        reader.endArray();
        return (T)obj;
    }

    private void writeObject(T object, ObjectWriter writer) {
        writer.beginObject();
        for (Map.Entry<String, Function<T, Number>> fieldExtractor : this.fieldExtractors.entrySet()) {
            writer.writeName(fieldExtractor.getKey());
            writer.writeValue(fieldExtractor.getValue().apply(object));
        }
        writer.endObject();
    }

    private T readObject(ObjectReader reader) {
        TemporalAmount obj = (TemporalAmount)this.instanceProvider.get();
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String applicatorName = reader.name();
            BiFunction<TemporalAmount, Number, TemporalAmount> applicator = this.fieldApplicatiors.get(applicatorName);
            obj = (TemporalAmount)applicator.apply(obj, reader.valueAsLong());
        }
        reader.endObject();
        return (T)obj;
    }

    static {
        PERIOD_FIELD_EXTRACTORS.put("years", Period::getYears);
        PERIOD_FIELD_EXTRACTORS.put("months", Period::getMonths);
        PERIOD_FIELD_EXTRACTORS.put("days", Period::getDays);
        PERIOD_FIELD_APPLICATORS = new LinkedHashMap();
        PERIOD_FIELD_APPLICATORS.put("years", (p, n) -> p.withYears(n.intValue()));
        PERIOD_FIELD_APPLICATORS.put("months", (p, n) -> p.withMonths(n.intValue()));
        PERIOD_FIELD_APPLICATORS.put("days", (p, n) -> p.withDays(n.intValue()));
        DURATION_FIELD_EXTRACTORS = new LinkedHashMap();
        DURATION_FIELD_EXTRACTORS.put("seconds", Duration::getSeconds);
        DURATION_FIELD_EXTRACTORS.put("nanos", Duration::getNano);
        DURATION_FIELD_APPLICATORS = new LinkedHashMap();
        DURATION_FIELD_APPLICATORS.put("seconds", (d, n) -> d.withSeconds(n.longValue()));
        DURATION_FIELD_APPLICATORS.put("nanos", (d, n) -> d.withNanos(n.intValue()));
    }
}

