/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.ext.javadatetime;

import com.owlike.genson.ext.javadatetime.BaseTemporalAccessorConverter;
import com.owlike.genson.ext.javadatetime.DateTimeConverterOptions;
import com.owlike.genson.ext.javadatetime.TimestampHandler;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.LinkedHashMap;

public class YearConverter
extends BaseTemporalAccessorConverter<Year> {
    YearConverter(DateTimeConverterOptions options) {
        super(options, new YearTimestampHandler(options), Year::from);
    }

    private static class YearTimestampHandler
    extends TimestampHandler<Year> {
        private static final LinkedHashMap<String, TemporalField> YEAR_TEMPORAL_FIELDS = new LinkedHashMap();

        private YearTimestampHandler(DateTimeConverterOptions options) {
            super(y -> y.getLong(ChronoField.YEAR), l -> Year.of(l.intValue()), y -> y.getLong(ChronoField.YEAR), l -> Year.of(l.intValue()), YEAR_TEMPORAL_FIELDS, Year::now);
        }

        static {
            YEAR_TEMPORAL_FIELDS.put("year", ChronoField.YEAR);
        }
    }
}

