/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.mqtt;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.heberling.ismart.asn1.AbstractMessage;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherHeader;
import net.heberling.ismart.asn1.v1_1.MessageCoder;
import net.heberling.ismart.asn1.v1_1.entity.Message;
import net.heberling.ismart.asn1.v1_1.entity.MessageListReq;
import net.heberling.ismart.asn1.v1_1.entity.MessageListResp;
import net.heberling.ismart.asn1.v1_1.entity.StartEndNumber;
import net.heberling.ismart.mqtt.SaicMessage;
import net.heberling.ismart.mqtt.SaicMqttGateway;
import org.bn.coders.IASN1PreparedElement;
import org.eclipse.paho.client.mqttv3.MqttException;

class MessageHandler
implements Runnable {
    private final String uid;
    private final String token;
    private final SaicMqttGateway gateway;

    public MessageHandler(String uid, String token, SaicMqttGateway gateway) {
        this.uid = uid;
        this.token = token;
        this.gateway = gateway;
    }

    @Override
    public void run() {
        MessageCoder<MessageListReq> messageListRequestMessageCoder = new MessageCoder<MessageListReq>(MessageListReq.class);
        MessageListReq messageListReq = new MessageListReq();
        messageListReq.setStartEndNumber(new StartEndNumber());
        messageListReq.getStartEndNumber().setStartNumber(1L);
        messageListReq.getStartEndNumber().setEndNumber(5L);
        messageListReq.setMessageGroup("ALARM");
        AbstractMessage messageListRequestMessage = messageListRequestMessageCoder.initializeMessage(this.uid, this.token, null, "531", 513, 1, (IASN1PreparedElement)messageListReq);
        ((MP_DispatcherHeader)messageListRequestMessage.getHeader()).setProtocolVersion(18);
        String messageListRequest = messageListRequestMessageCoder.encodeRequest((net.heberling.ismart.asn1.v1_1.Message<MessageListReq>)messageListRequestMessage);
        try {
            String messageListResponse = SaicMqttGateway.sendRequest(messageListRequest, "https://tap-eu.soimt.com/TAP.Web/ota.mp");
            AbstractMessage messageListResponseMessage = new MessageCoder<MessageListResp>(MessageListResp.class).decodeResponse(messageListResponse);
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new MessageCoder<MessageListResp>(MessageListResp.class), messageListResponseMessage)));
            if (messageListResponseMessage.getApplicationData() != null) {
                for (Message message : ((MessageListResp)messageListResponseMessage.getApplicationData()).getMessages()) {
                    this.gateway.notifyMessage(this.convert(message));
                }
            }
        }
        catch (IOException | MqttException e) {
            throw new RuntimeException(e);
        }
    }

    private SaicMessage convert(Message message) {
        return new SaicMessage(message.getMessageId(), message.getMessageType(), new String(message.getTitle(), StandardCharsets.UTF_8), ZonedDateTime.ofInstant(Instant.ofEpochSecond(message.getMessageTime().getSeconds()), ZoneId.systemDefault()), new String(message.getSender(), StandardCharsets.UTF_8), new String(message.getContent(), StandardCharsets.UTF_8), message.getReadStatus(), message.getVin());
    }
}

