/*
 * Decompiled with CFR 0.152.
 */
package org.bn;

import org.bn.IDecoder;
import org.bn.IEncoder;
import org.bn.coders.ASN1PreparedElementData;
import org.bn.coders.IASN1PreparedElementData;
import org.bn.coders.ber.BERDecoder;
import org.bn.coders.ber.BEREncoder;
import org.bn.coders.der.DERDecoder;
import org.bn.coders.der.DEREncoder;
import org.bn.coders.per.PERAlignedDecoder;
import org.bn.coders.per.PERAlignedEncoder;
import org.bn.coders.per.PERUnalignedDecoder;
import org.bn.coders.per.PERUnalignedEncoder;

public class CoderFactory {
    private static final CoderFactory INSTANCE = new CoderFactory();

    public static CoderFactory getInstance() {
        return INSTANCE;
    }

    public IEncoder newEncoder() {
        return this.newEncoder("BER");
    }

    public IEncoder newEncoder(String encodingSchema) {
        if (encodingSchema.equalsIgnoreCase("BER")) {
            return new BEREncoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER") || encodingSchema.equalsIgnoreCase("PER/Aligned") || encodingSchema.equalsIgnoreCase("PER/A")) {
            return new PERAlignedEncoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER/Unaligned") || encodingSchema.equalsIgnoreCase("PER/U")) {
            return new PERUnalignedEncoder();
        }
        if (encodingSchema.equalsIgnoreCase("DER")) {
            return new DEREncoder();
        }
        throw new IllegalArgumentException("Unknown encoding schema '" + encodingSchema + "'");
    }

    public IDecoder newDecoder() {
        return this.newDecoder("BER");
    }

    public IDecoder newDecoder(String encodingSchema) {
        if (encodingSchema.equalsIgnoreCase("BER")) {
            return new BERDecoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER") || encodingSchema.equalsIgnoreCase("PER/Aligned") || encodingSchema.equalsIgnoreCase("PER/A")) {
            return new PERAlignedDecoder();
        }
        if (encodingSchema.equalsIgnoreCase("PER") || encodingSchema.equalsIgnoreCase("PER/Unaligned") || encodingSchema.equalsIgnoreCase("PER/U")) {
            return new PERUnalignedDecoder();
        }
        if (encodingSchema.equalsIgnoreCase("DER")) {
            return new DERDecoder();
        }
        throw new IllegalArgumentException("Unknown encoding schema '" + encodingSchema + "'");
    }

    public IASN1PreparedElementData newPreparedElementData(Class<?> typeInfo) {
        return new ASN1PreparedElementData(typeInfo);
    }
}

