/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.mqtt;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.heberling.ismart.asn1.v1_1.MP_DispatcherHeader;
import net.heberling.ismart.asn1.v1_1.Message;
import net.heberling.ismart.asn1.v1_1.MessageCoder;
import net.heberling.ismart.asn1.v1_1.entity.MessageListReq;
import net.heberling.ismart.asn1.v1_1.entity.MessageListResp;
import net.heberling.ismart.asn1.v1_1.entity.StartEndNumber;
import net.heberling.ismart.mqtt.SaicMessage;
import net.heberling.ismart.mqtt.SaicMqttGateway;
import org.bn.coders.IASN1PreparedElement;
import org.eclipse.paho.client.mqttv3.MqttException;

class MessageHandler
implements Runnable {
    private final String uid;
    private final String token;
    private final SaicMqttGateway gateway;

    public MessageHandler(String uid, String token, SaicMqttGateway gateway) {
        this.uid = uid;
        this.token = token;
        this.gateway = gateway;
    }

    @Override
    public void run() {
        MessageCoder messageListRequestMessageCoder = new MessageCoder(MessageListReq.class);
        MessageListReq messageListReq = new MessageListReq();
        messageListReq.setStartEndNumber(new StartEndNumber());
        messageListReq.getStartEndNumber().setStartNumber(Long.valueOf(1L));
        messageListReq.getStartEndNumber().setEndNumber(Long.valueOf(5L));
        messageListReq.setMessageGroup("ALARM");
        Message messageListRequestMessage = messageListRequestMessageCoder.initializeMessage(this.uid, this.token, null, "531", 513, 1, (IASN1PreparedElement)messageListReq);
        ((MP_DispatcherHeader)messageListRequestMessage.getHeader()).setProtocolVersion(Integer.valueOf(18));
        String messageListRequest = messageListRequestMessageCoder.encodeRequest(messageListRequestMessage);
        try {
            String messageListResponse = SaicMqttGateway.sendRequest(messageListRequest, "https://tap-eu.soimt.com/TAP.Web/ota.mp");
            Message messageListResponseMessage = new MessageCoder(MessageListResp.class).decodeResponse(messageListResponse);
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new MessageCoder(MessageListResp.class), messageListResponseMessage)));
            if (messageListResponseMessage.getApplicationData() != null) {
                for (net.heberling.ismart.asn1.v1_1.entity.Message message : ((MessageListResp)messageListResponseMessage.getApplicationData()).getMessages()) {
                    this.gateway.notifyMessage(this.convert(message));
                }
            }
        }
        catch (IOException | MqttException e) {
            throw new RuntimeException(e);
        }
    }

    private SaicMessage convert(net.heberling.ismart.asn1.v1_1.entity.Message message) {
        return new SaicMessage(message.getMessageId(), message.getMessageType(), new String(message.getTitle(), StandardCharsets.UTF_8), ZonedDateTime.ofInstant(Instant.ofEpochSecond(message.getMessageTime().getSeconds()), ZoneId.systemDefault()), new String(message.getSender(), StandardCharsets.UTF_8), new String(message.getContent(), StandardCharsets.UTF_8), message.getReadStatus(), message.getVin());
    }
}

