/*
 * Decompiled with CFR 0.152.
 */
package net.heberling.ismart.mqtt;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import net.heberling.ismart.asn1.v1_1.entity.VinInfo;
import net.heberling.ismart.asn1.v2_1.Message;
import net.heberling.ismart.asn1.v2_1.MessageCoder;
import net.heberling.ismart.asn1.v2_1.entity.OTA_RVMVehicleStatusReq;
import net.heberling.ismart.asn1.v2_1.entity.OTA_RVMVehicleStatusResp25857;
import net.heberling.ismart.asn1.v3_0.MP_DispatcherBody;
import net.heberling.ismart.asn1.v3_0.entity.OTA_ChrgMangDataResp;
import net.heberling.ismart.mqtt.SaicMessage;
import net.heberling.ismart.mqtt.SaicMqttGateway;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.bn.coders.IASN1PreparedElement;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class VehicleHandler {
    private String uid;
    private String token;
    private VinInfo vinInfo;
    private SaicMqttGateway saicMqttGateway;
    private IMqttClient client;
    private ZonedDateTime lastCarActivity;
    private ZonedDateTime lastVehicleMessage;

    public VehicleHandler(SaicMqttGateway saicMqttGateway, IMqttClient client, String uid, String token, VinInfo vinInfo) {
        this.saicMqttGateway = saicMqttGateway;
        this.client = client;
        this.uid = uid;
        this.token = token;
        this.vinInfo = vinInfo;
    }

    void handleVehicle() throws MqttException, IOException {
        MqttMessage msg = new MqttMessage(this.vinInfo.getModelConfigurationJsonStr().getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        this.client.publish("saic/vehicle/" + this.vinInfo.getVin() + "/configuration/raw", msg);
        for (String c : this.vinInfo.getModelConfigurationJsonStr().split(";")) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String e : c.split(",")) {
                map.put(e.split(":")[0], e.split(":")[1]);
            }
            msg = new MqttMessage(SaicMqttGateway.toJSON(map).getBytes(StandardCharsets.UTF_8));
            msg.setQos(0);
            msg.setRetained(true);
            this.client.publish("saic/vehicle/" + this.vinInfo.getVin() + "/configuration/" + (String)map.get("code"), msg);
        }
        this.notifyCarActivity(ZonedDateTime.now(), true);
        while (true) {
            if (this.lastCarActivity.isAfter(ZonedDateTime.now().minus(15L, ChronoUnit.MINUTES))) {
                OTA_RVMVehicleStatusResp25857 vehicleStatus = this.updateVehicleStatus(this.client, this.uid, this.token, this.vinInfo.getVin());
                OTA_ChrgMangDataResp chargeStatus = VehicleHandler.updateChargeStatus(this.client, this.uid, this.token, this.vinInfo.getVin());
                this.updateAbrp(vehicleStatus, chargeStatus);
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void updateAbrp(OTA_RVMVehicleStatusResp25857 vehicleStatus, OTA_ChrgMangDataResp chargeStatus) throws MqttException {
        String abrpUserToken = this.saicMqttGateway.getAbrpUserToken(this.vinInfo.getVin());
        if (this.saicMqttGateway.getAbrpApiKey() != null && abrpUserToken != null && vehicleStatus != null && chargeStatus != null) {
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HashMap<String, Serializable> map = new HashMap<String, Serializable>();
                map.put("utc", vehicleStatus.getGpsPosition().getTimestamp4Short().getSeconds());
                map.put("soc", Double.valueOf((double)chargeStatus.getBmsPackSOCDsp().intValue() / 10.0));
                double current = (double)chargeStatus.getBmsPackCrnt().intValue() * 0.05 - 1000.0;
                double voltage = (double)chargeStatus.getBmsPackVol().intValue() * 0.25;
                double power = current * voltage / 1000.0;
                map.put("power", Double.valueOf(power));
                map.put("speed", Double.valueOf((double)vehicleStatus.getGpsPosition().getWayPoint().getSpeed().intValue() / 10.0));
                map.put("lat", Double.valueOf((double)vehicleStatus.getGpsPosition().getWayPoint().getPosition().getLatitude().intValue() / 1000000.0));
                map.put("lon", Double.valueOf((double)vehicleStatus.getGpsPosition().getWayPoint().getPosition().getLongitude().intValue() / 1000000.0));
                boolean isCharging = vehicleStatus.getBasicVehicleStatus().isExtendedData2Present() && vehicleStatus.getBasicVehicleStatus().getExtendedData2() >= 1;
                map.put("is_charging", Boolean.valueOf(isCharging));
                map.put("is_parked", Boolean.valueOf(vehicleStatus.getBasicVehicleStatus().getEngineStatus() != 1 || vehicleStatus.getBasicVehicleStatus().getHandBrake() != false));
                map.put("heading", vehicleStatus.getGpsPosition().getWayPoint().getHeading());
                map.put("elevation", vehicleStatus.getGpsPosition().getWayPoint().getPosition().getAltitude());
                if (vehicleStatus.getBasicVehicleStatus().getExteriorTemperature() != -128) {
                    map.put("ext_temp", vehicleStatus.getBasicVehicleStatus().getExteriorTemperature());
                }
                map.put("voltage", Double.valueOf(voltage));
                map.put("current", Double.valueOf(current));
                if (vehicleStatus.getBasicVehicleStatus().getMileage() > 0) {
                    map.put("odometer", Double.valueOf((double)vehicleStatus.getBasicVehicleStatus().getMileage().intValue() / 10.0));
                }
                if (vehicleStatus.getBasicVehicleStatus().getFuelRangeElec() > 0) {
                    map.put("est_battery_range", Double.valueOf((double)vehicleStatus.getBasicVehicleStatus().getFuelRangeElec().intValue() / 10.0));
                }
                String request = "token=" + abrpUserToken + "&tlm=" + URLEncoder.encode(SaicMqttGateway.toJSON(map), StandardCharsets.UTF_8);
                HttpGet httppost = new HttpGet("https://api.iternio.com/1/tlm/send?api_key=" + this.saicMqttGateway.getAbrpApiKey() + "&" + request);
                HttpClientResponseHandler responseHandler = response -> {
                    int status = response.getCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        try {
                            return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                        }
                        catch (ParseException ex) {
                            throw new ClientProtocolException((Throwable)ex);
                        }
                    }
                    HttpEntity entity = response.getEntity();
                    try {
                        if (entity != null) {
                            throw new ClientProtocolException("Unexpected response status: " + status + " Content: " + EntityUtils.toString((HttpEntity)entity));
                        }
                        throw new ClientProtocolException("Unexpected response status: " + status);
                    }
                    catch (ParseException ex) {
                        throw new ClientProtocolException((Throwable)ex);
                    }
                };
                String execute = (String)httpclient.execute((ClassicHttpRequest)httppost, responseHandler);
                System.out.println("ABRP: " + execute);
                MqttMessage msg = new MqttMessage(execute.getBytes(StandardCharsets.UTF_8));
                msg.setQos(0);
                msg.setRetained(true);
                this.client.publish("saic/vehicle/" + this.vinInfo.getVin() + "/abrp", msg);
            }
            catch (Exception e) {
                System.out.println("ABRP failed.:");
                e.printStackTrace();
                MqttMessage msg = new MqttMessage(e.toString().getBytes(StandardCharsets.UTF_8));
                msg.setQos(0);
                msg.setRetained(true);
                this.client.publish("saic/vehicle/" + this.vinInfo.getVin() + "/abrp", msg);
            }
        }
    }

    private OTA_RVMVehicleStatusResp25857 updateVehicleStatus(IMqttClient client, String uid, String token, String vin) throws IOException, MqttException {
        Integer exteriorTemperature;
        boolean isCharging;
        MessageCoder otaRvmVehicleStatusReqMessageCoder = new MessageCoder(OTA_RVMVehicleStatusReq.class);
        OTA_RVMVehicleStatusReq otaRvmVehicleStatusReq = new OTA_RVMVehicleStatusReq();
        otaRvmVehicleStatusReq.setVehStatusReqType(Integer.valueOf(2));
        Message chargingStatusMessage = otaRvmVehicleStatusReqMessageCoder.initializeMessage(uid, token, vin, "511", 25857, 1, (IASN1PreparedElement)otaRvmVehicleStatusReq);
        String chargingStatusRequestMessage = otaRvmVehicleStatusReqMessageCoder.encodeRequest(chargingStatusMessage);
        String chargingStatusResponse = SaicMqttGateway.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv21");
        Message chargingStatusResponseMessage = new MessageCoder(OTA_RVMVehicleStatusResp25857.class).decodeResponse(chargingStatusResponse);
        ((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusMessage.getBody()).setEventID(((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getEventID());
        while (chargingStatusResponseMessage.getApplicationData() == null) {
            if (((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).isErrorMessagePresent()) {
                if (((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getResult() == 2) {
                    // empty if block
                }
                return null;
            }
            ((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusMessage.getBody()).setUid(uid);
            ((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusMessage.getBody()).setToken(token);
            SaicMqttGateway.fillReserved(chargingStatusMessage.getReserved());
            chargingStatusRequestMessage = otaRvmVehicleStatusReqMessageCoder.encodeRequest(chargingStatusMessage);
            chargingStatusResponse = SaicMqttGateway.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv21");
            chargingStatusResponseMessage = new MessageCoder(OTA_RVMVehicleStatusResp25857.class).decodeResponse(chargingStatusResponse);
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new MessageCoder(OTA_RVMVehicleStatusResp25857.class), chargingStatusResponseMessage)));
        }
        boolean engineRunning = ((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getEngineStatus() == 1;
        boolean bl = isCharging = ((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().isExtendedData2Present() && ((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getExtendedData2() >= 1;
        if (isCharging || engineRunning) {
            this.notifyCarActivity(ZonedDateTime.now(), false);
        }
        MqttMessage msg = new MqttMessage(chargingStatusResponse.getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/" + ((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationID() + "_" + ((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationDataProtocolVersion() + "/raw", msg);
        msg = new MqttMessage(SaicMqttGateway.toJSON(chargingStatusResponseMessage).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/" + ((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationID() + "_" + ((net.heberling.ismart.asn1.v2_1.MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationDataProtocolVersion() + "/json", msg);
        msg = new MqttMessage(String.valueOf(engineRunning).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/running", msg);
        msg = new MqttMessage(String.valueOf(isCharging).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/charging", msg);
        Integer interiorTemperature = ((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getInteriorTemperature();
        if (interiorTemperature > -128) {
            msg = new MqttMessage(String.valueOf(interiorTemperature).getBytes(StandardCharsets.UTF_8));
            msg.setQos(0);
            msg.setRetained(true);
            client.publish("saic/vehicle/" + vin + "/temperature/interior", msg);
        }
        if ((exteriorTemperature = ((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getExteriorTemperature()) > -128) {
            msg = new MqttMessage(String.valueOf(exteriorTemperature).getBytes(StandardCharsets.UTF_8));
            msg.setQos(0);
            msg.setRetained(true);
            client.publish("saic/vehicle/" + vin + "/temperature/exterior", msg);
        }
        msg = new MqttMessage(String.valueOf((double)((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getBatteryVoltage().intValue() / 10.0).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/auxillary_battery", msg);
        msg = new MqttMessage(SaicMqttGateway.toJSON(((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getGpsPosition()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/gps/json", msg);
        msg = new MqttMessage(String.valueOf((double)((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getGpsPosition().getWayPoint().getSpeed().intValue() / 10.0).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/speed", msg);
        msg = new MqttMessage(String.valueOf(((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getLockStatus()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/locked", msg);
        msg = new MqttMessage(String.valueOf(((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getRemoteClimateStatus()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/remoteClimate", msg);
        msg = new MqttMessage(String.valueOf(((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getRmtHtdRrWndSt()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        client.publish("saic/vehicle/" + vin + "/remoteRearWindowHeater", msg);
        if (((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getMileage() > 0) {
            msg = new MqttMessage(String.valueOf((double)((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getMileage().intValue() / 10.0).getBytes(StandardCharsets.UTF_8));
            msg.setQos(0);
            msg.setRetained(true);
            client.publish("saic/vehicle/" + vin + "/milage", msg);
            msg = new MqttMessage(String.valueOf((double)((OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData()).getBasicVehicleStatus().getFuelRangeElec().intValue() / 10.0).getBytes(StandardCharsets.UTF_8));
            msg.setQos(0);
            msg.setRetained(true);
            client.publish("saic/vehicle/" + vin + "/range/electric", msg);
        }
        return (OTA_RVMVehicleStatusResp25857)chargingStatusResponseMessage.getApplicationData();
    }

    private static OTA_ChrgMangDataResp updateChargeStatus(IMqttClient publisher, String uid, String token, String vin) throws IOException, MqttException {
        net.heberling.ismart.asn1.v3_0.MessageCoder chargingStatusRequestMessageEncoder = new net.heberling.ismart.asn1.v3_0.MessageCoder(IASN1PreparedElement.class);
        net.heberling.ismart.asn1.v3_0.Message chargingStatusMessage = chargingStatusRequestMessageEncoder.initializeMessage(uid, token, vin, "516", 768, 5, null);
        String chargingStatusRequestMessage = chargingStatusRequestMessageEncoder.encodeRequest(chargingStatusMessage);
        System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(chargingStatusRequestMessageEncoder, chargingStatusMessage)));
        String chargingStatusResponse = SaicMqttGateway.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv30");
        net.heberling.ismart.asn1.v3_0.Message chargingStatusResponseMessage = new net.heberling.ismart.asn1.v3_0.MessageCoder(OTA_ChrgMangDataResp.class).decodeResponse(chargingStatusResponse);
        System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new net.heberling.ismart.asn1.v3_0.MessageCoder(OTA_ChrgMangDataResp.class), chargingStatusResponseMessage)));
        ((MP_DispatcherBody)chargingStatusMessage.getBody()).setEventID(((MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getEventID());
        while (chargingStatusResponseMessage.getApplicationData() == null) {
            if (((MP_DispatcherBody)chargingStatusResponseMessage.getBody()).isErrorMessagePresent()) {
                if (((MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getResult() == 2) {
                    // empty if block
                }
                return null;
            }
            SaicMqttGateway.fillReserved(chargingStatusMessage.getReserved());
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(chargingStatusRequestMessageEncoder, chargingStatusMessage)));
            chargingStatusRequestMessage = chargingStatusRequestMessageEncoder.encodeRequest(chargingStatusMessage);
            chargingStatusResponse = SaicMqttGateway.sendRequest(chargingStatusRequestMessage, "https://tap-eu.soimt.com/TAP.Web/ota.mpv30");
            chargingStatusResponseMessage = new net.heberling.ismart.asn1.v3_0.MessageCoder(OTA_ChrgMangDataResp.class).decodeResponse(chargingStatusResponse);
            System.out.println(SaicMqttGateway.toJSON(SaicMqttGateway.anonymized(new net.heberling.ismart.asn1.v3_0.MessageCoder(OTA_ChrgMangDataResp.class), chargingStatusResponseMessage)));
        }
        MqttMessage msg = new MqttMessage(chargingStatusResponse.getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/" + ((MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationID() + "_" + ((MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationDataProtocolVersion() + "/raw", msg);
        msg = new MqttMessage(SaicMqttGateway.toJSON(chargingStatusResponseMessage).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/" + ((MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationID() + "_" + ((MP_DispatcherBody)chargingStatusResponseMessage.getBody()).getApplicationDataProtocolVersion() + "/json", msg);
        double current = (double)((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsPackCrnt().intValue() * 0.05 - 1000.0;
        msg = new MqttMessage(String.valueOf(current).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/current", msg);
        double voltage = (double)((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsPackVol().intValue() * 0.25;
        msg = new MqttMessage(String.valueOf(voltage).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/voltage", msg);
        double power = current * voltage / 1000.0;
        msg = new MqttMessage(String.valueOf(power).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/power", msg);
        msg = new MqttMessage(String.valueOf(((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getChargeStatus().getChargingType()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/charge/type", msg);
        msg = new MqttMessage(String.valueOf(((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsChrgCtrlDspCmd()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/bms/bmsChrgCtrlDspCmd", msg);
        msg = new MqttMessage(String.valueOf(((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsChrgOtptCrntReq()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/bms/bmsChrgOtptCrntReq", msg);
        msg = new MqttMessage(String.valueOf(((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsChrgSts()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/bms/bmsChrgSts", msg);
        msg = new MqttMessage(String.valueOf(((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsPackCrnt()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/bms/bmsPackCrnt", msg);
        msg = new MqttMessage(String.valueOf(((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsPackVol() / 4).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/bms/bmsPackVol", msg);
        msg = new MqttMessage(String.valueOf(((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsPTCHeatReqDspCmd()).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/bms/bmsPTCHeatReqDspCmd", msg);
        msg = new MqttMessage(String.valueOf((double)((OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData()).getBmsPackSOCDsp().intValue() / 10.0).getBytes(StandardCharsets.UTF_8));
        msg.setQos(0);
        msg.setRetained(true);
        publisher.publish("saic/vehicle/" + vin + "/soc", msg);
        return (OTA_ChrgMangDataResp)chargingStatusResponseMessage.getApplicationData();
    }

    public void notifyCarActivity(ZonedDateTime now, boolean force) throws MqttException {
        if (this.lastCarActivity == null || force || this.lastCarActivity.isBefore(now)) {
            this.lastCarActivity = now;
            MqttMessage msg = new MqttMessage(SaicMqttGateway.toJSON(this.lastCarActivity).getBytes(StandardCharsets.UTF_8));
            msg.setQos(0);
            msg.setRetained(true);
            this.client.publish("saic/vehicle/" + this.vinInfo.getVin() + "/last_activity", msg);
        }
    }

    public void notifyMessage(SaicMessage message) throws MqttException {
        if (this.lastVehicleMessage == null || message.getMessageTime().isAfter(this.lastVehicleMessage)) {
            MqttMessage msg = new MqttMessage(SaicMqttGateway.toJSON(message).getBytes(StandardCharsets.UTF_8));
            msg.setQos(0);
            msg.setRetained(true);
            this.client.publish("saic/vehicle/" + this.vinInfo.getVin() + "/message", msg);
            this.lastVehicleMessage = message.getMessageTime();
        }
        this.notifyCarActivity(message.getMessageTime(), false);
    }
}

