/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JTextPane;

public class JTextFieldInputStream
extends InputStream {
    int[] contents = new int[20];
    int pointer = -1;
    private Object semaphore = new Object();

    public JTextFieldInputStream(JTextPane text) {
        text.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyTyped(KeyEvent e) {
                if (JTextFieldInputStream.this.pointer > JTextFieldInputStream.this.contents.length - 2) {
                    JTextFieldInputStream.this.contents = Arrays.copyOf(JTextFieldInputStream.this.contents, JTextFieldInputStream.this.contents.length * 2);
                }
                JTextFieldInputStream.this.contents[JTextFieldInputStream.this.pointer + 1] = e.getKeyChar();
                ++JTextFieldInputStream.this.pointer;
                super.keyReleased(e);
                Object object = JTextFieldInputStream.this.semaphore;
                synchronized (object) {
                    JTextFieldInputStream.this.semaphore.notify();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            Object object = this.semaphore;
            synchronized (object) {
                this.semaphore.wait();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException(t);
        }
        return super.read(b, off, len > 1024 ? 1024 : len);
    }

    @Override
    public int read() throws IOException {
        if (this.pointer >= this.contents.length || this.pointer < 0) {
            return -1;
        }
        --this.pointer;
        return this.contents[0];
    }

    @Override
    public int available() throws IOException {
        return this.pointer + 1;
    }
}

