/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.ribbon;

import com.formdev.flatlaf.icons.FlatWindowCloseIcon;
import com.formdev.flatlaf.icons.FlatWindowIconifyIcon;
import com.formdev.flatlaf.icons.FlatWindowMaximizeIcon;
import com.formdev.flatlaf.icons.FlatWindowRestoreIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;
import net.hironico.common.swing.ribbon.Ribbon;

public class RibbonWindowUI
extends LayerUI<Ribbon> {
    protected final Color hoverBackground = UIManager.getColor("TitlePane.closeHoverBackground");
    private RibbonCloseIcon iconClose = null;
    private Icon iconMaximize = null;
    private Icon iconRestore = null;
    private Icon iconMinimize = null;

    public RibbonWindowUI() {
        this.initialize();
    }

    private void initialize() {
        this.iconClose = new RibbonCloseIcon();
        this.iconMaximize = new FlatWindowMaximizeIcon();
        this.iconRestore = new FlatWindowRestoreIcon();
        this.iconMinimize = new FlatWindowIconifyIcon();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int w = c.getWidth();
        int h = c.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        if (!c.isVisible() || !c.isValid()) {
            return;
        }
        super.paint(g, c);
        int iconWidth = this.iconClose.getIconWidth();
        int iconHeight = this.iconClose.getIconHeight();
        if (this.iconClose.isSelected()) {
            g.setColor(this.hoverBackground);
            g.fillRect(w - iconWidth, 0, iconWidth, iconHeight);
        }
        this.iconClose.paintIcon(c, g, w - iconWidth, 0);
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(c);
        if (topFrame.getExtendedState() == 6) {
            this.iconRestore.paintIcon(c, g, w - iconWidth * 2, 0);
        } else {
            this.iconMaximize.paintIcon(c, g, w - iconWidth * 2, 0);
        }
        this.iconMinimize.paintIcon(c, g, w - iconWidth * 3, 0);
    }

    @Override
    protected void processMouseEvent(MouseEvent e, JLayer<? extends Ribbon> l) {
        if (e.getClickCount() != 1 || e.getID() != 500) {
            return;
        }
        Ribbon ribbon = l.getView();
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(ribbon);
        if (this.isOverIcon((Icon)((Object)this.iconClose), e, l)) {
            if (ribbon.getExitAction() != null) {
                ribbon.getExitAction().actionPerformed(null);
            } else {
                topFrame.dispatchEvent(new WindowEvent(topFrame, 201));
            }
        }
        if (this.isOverIcon(this.iconMaximize, e, l)) {
            if (topFrame.getExtendedState() != 6) {
                topFrame.setExtendedState(6);
            } else {
                topFrame.setExtendedState(0);
            }
        }
        if (this.isOverIcon(this.iconMinimize, e, l)) {
            topFrame.setExtendedState(1);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends Ribbon> l) {
        if (this.isOverIcon((Icon)((Object)this.iconClose), e, l)) {
            this.iconClose.setSelected(true);
            l.repaint();
        } else {
            this.iconClose.setSelected(false);
            l.repaint();
        }
    }

    private boolean isOverIcon(Icon icon, MouseEvent evt, JLayer<? extends Ribbon> layer) {
        int w = layer.getWidth();
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        int x = w - iconWidth - 5;
        if (icon.equals(this.iconMaximize)) {
            x = w - iconWidth * 2 - 5;
        }
        if (icon.equals(this.iconMinimize)) {
            x = w - iconWidth * 3 - 5;
        }
        Rectangle rect = new Rectangle(x, 2, iconWidth, iconHeight);
        return rect.contains(evt.getPoint());
    }

    static class RibbonCloseIcon
    extends FlatWindowCloseIcon {
        private boolean selected = false;
        protected final Color hoverForeground = UIManager.getColor("TitlePane.closeHoverForeground");

        RibbonCloseIcon() {
        }

        protected Color getForeground(Component c) {
            return this.selected ? this.hoverForeground : super.getForeground(c);
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

