/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

public class EntitiesUtils {
    public static <T> List<T> saveEntities(EntityManager entityManager, T ... entities) throws Exception {
        try {
            EntityTransaction tran = entityManager.getTransaction();
            tran.begin();
            ArrayList<Object> result = new ArrayList<Object>();
            for (T entity : entities) {
                result.add(entityManager.merge(entity));
            }
            if (tran.isActive()) {
                tran.commit();
            }
            return result;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    public static <T> T saveEntity(EntityManager entityManager, T entity) throws Exception {
        try {
            EntityTransaction tran = entityManager.getTransaction();
            tran.begin();
            entity = entityManager.merge(entity);
            if (tran.isActive()) {
                tran.commit();
            }
            return entity;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    public static void removeEntity(EntityManager entityManager, Object entity) throws Exception {
        try {
            EntityTransaction tran = entityManager.getTransaction();
            tran.begin();
            entityManager.remove(entity);
            if (tran.isActive()) {
                tran.commit();
            }
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    public static void removeEntities(EntityManager entityManager, Object ... entities) throws Exception {
        if (entities.length == 0) {
            return;
        }
        try {
            EntityTransaction tran = entityManager.getTransaction();
            tran.begin();
            for (Object entity : entities) {
                entityManager.remove(entity);
            }
            if (tran.isActive()) {
                tran.commit();
            }
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }
}

