/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jdesktop.swingx.VerticalLayout;

public class BannerPanel
extends JPanel {
    private String title;
    private String description;
    private Color primaryColor;
    private Color secondaryColor;
    private Color titleColor = Color.BLACK;
    private Color descriptionColor = Color.BLACK;
    private JLabel lblTitle;
    private JTextPane lblDescription;

    public BannerPanel() {
        this("Title", "Description");
    }

    public BannerPanel(String title, String description) {
        this(title, description, Color.LIGHT_GRAY, Color.WHITE);
    }

    public BannerPanel(String title, String description, Color primaryColor, Color secondaryColor) {
        this.title = title;
        this.description = description;
        this.setPrimaryColor(primaryColor);
        this.setSecondaryColor(secondaryColor);
        this.initialize();
    }

    private void initialize() {
        this.setLayout((LayoutManager)new VerticalLayout());
        this.add(this.getLblTitle());
        this.add(this.getLblDescription());
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(this.getTitle());
            Font font = this.lblTitle.getFont();
            this.lblTitle.setFont(new Font(font.getName(), font.getStyle(), 25));
        }
        return this.lblTitle;
    }

    private JTextPane getLblDescription() {
        if (this.lblDescription == null) {
            this.lblDescription = new JTextPane();
            this.lblDescription.setText(this.getDescription());
            this.lblDescription.setOpaque(false);
            Font font = this.lblTitle.getFont();
            this.lblTitle.setFont(new Font(font.getName(), 0, font.getSize()));
        }
        return this.lblDescription;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, this.getPrimaryColor(), width, height, this.getSecondaryColor());
        g2d.setPaint(gp);
        g2d.fillRect(0, 0, width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 100);
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(Color primaryColor) {
        this.primaryColor = primaryColor;
    }

    public Color getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(Color secondaryColor) {
        this.secondaryColor = secondaryColor;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Color getDescriptionColor() {
        return this.descriptionColor;
    }

    public void setDescriptionColor(Color descriptionColor) {
        this.descriptionColor = descriptionColor;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTitle(String title) {
        this.title = title;
        this.getLblTitle().setText(title);
    }

    public void setDescription(String description) {
        this.description = description;
        this.getLblDescription().setText(description);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Gradient Panel");
        frame.setDefaultCloseOperation(3);
        BannerPanel panel = new BannerPanel("Title", "Description");
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

