/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class FilteredListModel<T>
extends AbstractListModel<T> {
    private static final long serialVersionUID = 1L;
    private final ListModel<T> _source;
    private Filter _filter;
    private final ArrayList<Integer> _indices = new ArrayList();

    public FilteredListModel(ListModel<T> source) {
        if (source == null) {
            throw new IllegalArgumentException("Source is null");
        }
        this._source = source;
        this._source.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                FilteredListModel.this.doFilter();
            }
        });
    }

    public void setFilter(Filter f) {
        this._filter = f;
        this.doFilter();
    }

    public void doFilter() {
        this._indices.clear();
        Filter f = this._filter;
        if (f != null) {
            int count = this._source.getSize();
            for (int i = 0; i < count; ++i) {
                T element = this._source.getElementAt(i);
                if (!f.accept(element)) continue;
                this._indices.add(i);
            }
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    @Override
    public int getSize() {
        return this._filter != null ? this._indices.size() : this._source.getSize();
    }

    @Override
    public T getElementAt(int index) {
        return this._filter != null ? this._source.getElementAt(this._indices.get(index)) : this._source.getElementAt(index);
    }

    public static interface Filter {
        public boolean accept(Object var1);
    }
}

