/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.image;

import java.awt.Image;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ImageIconUtils {
    private static final Logger LOGGER = Logger.getLogger(ImageIconUtils.class.getName());

    public static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = ImageIconUtils.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        LOGGER.severe(String.format("Couldn't find file: %s", path));
        return null;
    }

    public static ImageIcon getScaledImage(ImageIcon imageIcon, int w, int h) {
        if (imageIcon == null) {
            return null;
        }
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(w, h, 4);
        imageIcon = new ImageIcon(newimg);
        return imageIcon;
    }
}

