/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.ribbon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.hironico.common.swing.ribbon.AbstractRibbonAction;

public class RibbonGroup
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(RibbonGroup.class.getName());
    protected String title;
    protected JLabel lblTitle = null;
    protected JPanel pnlTitle = null;
    protected JPanel pnlCommands = null;
    public static final int SMALL = 0;
    public static final int LARGE = 3;
    private int currentRow = 0;
    private int currentColumn = 0;

    public RibbonGroup(String title) {
        this.title = title;
        this.initialize();
    }

    public void addCheckBox(AbstractRibbonAction action) {
        JCheckBox chk = new JCheckBox(action);
        chk.setMinimumSize(new Dimension(24, 24));
        this.addActionComponent(chk, 0);
    }

    public void addButton(AbstractRibbonAction action, int size) {
        this.addActionComponent(new JButton(action), size);
    }

    public void addToggle(AbstractRibbonAction action, int size) {
        this.addActionComponent(new JToggleButton(action), size);
    }

    private void addActionComponent(final AbstractButton btn, int size) {
        if (!(btn.getAction() instanceof AbstractRibbonAction)) {
            LOGGER.severe("Cannot add action to RibbonGroup. Action must be a subclass of AbstractRibbonAction.");
            throw new IllegalArgumentException("Cannot add action to RibbonGroup. Action must be a subclass of AbstractRibbonAction.");
        }
        AbstractRibbonAction action = (AbstractRibbonAction)btn.getAction();
        btn.setText((String)action.getValue("Name"));
        btn.setToolTipText((String)action.getValue("ShortDescription"));
        if (size == 3 && this.currentRow > 0) {
            for (int time = 0; time < 3 - this.currentRow; ++time) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.insets = new Insets(2, 2, 2, 2);
                gbc.gridx = this.currentColumn;
                gbc.gridy = this.currentRow;
                gbc.fill = 3;
                gbc.gridheight = 1;
                gbc.weighty = 0.33;
                JPanel pnlZero = new JPanel();
                this.pnlCommands.add((Component)pnlZero, gbc);
            }
            this.currentRow = 0;
            ++this.currentColumn;
        }
        if (size == 3) {
            btn.setIcon(action.getLargeIcon());
            btn.setVerticalTextPosition(3);
            btn.setHorizontalTextPosition(0);
            btn.setMinimumSize(new Dimension(48, 48));
        } else {
            btn.setIcon(action.getSmallIcon());
            btn.setMinimumSize(new Dimension(24, 24));
        }
        btn.setContentAreaFilled(!(btn instanceof JButton));
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                btn.setContentAreaFilled(!(btn instanceof JButton));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                btn.setContentAreaFilled(true);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridx = this.currentColumn;
        gbc.gridy = this.currentRow;
        gbc.fill = 3;
        gbc.anchor = 17;
        switch (size) {
            case 0: {
                gbc.gridheight = 1;
                gbc.weighty = 0.33;
                break;
            }
            case 3: {
                gbc.gridheight = 3;
                gbc.weighty = 1.0;
                btn.setHorizontalTextPosition(0);
                btn.setVerticalTextPosition(3);
                break;
            }
            default: {
                gbc.gridheight = 1;
            }
        }
        this.getPnlCommands().add((Component)btn, gbc);
        if (btn.getHeight() < 16) {
            btn.setSize(btn.getWidth(), 16);
        }
        if (size == 3 || this.currentRow == 2) {
            this.currentRow = 0;
            ++this.currentColumn;
        } else {
            ++this.currentRow;
        }
    }

    protected void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setOpaque(false);
        this.add((Component)this.getPnlCommands(), "Center");
        this.add((Component)this.getPnlTitle(), "South");
    }

    protected JPanel getPnlCommands() {
        if (this.pnlCommands == null) {
            this.pnlCommands = new JPanel();
            this.pnlCommands.setLayout(new GridBagLayout());
            this.pnlCommands.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.pnlCommands.setOpaque(false);
        }
        return this.pnlCommands;
    }

    protected JPanel getPnlTitle() {
        if (this.pnlTitle == null) {
            this.pnlTitle = new JPanel();
            this.pnlTitle.setLayout(new BoxLayout(this.pnlTitle, 1));
            this.pnlTitle.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.pnlTitle.setOpaque(false);
            this.pnlTitle.add(this.getLblTitle());
        }
        return this.pnlTitle;
    }

    protected JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel(this.title);
            this.lblTitle.setBorder(BorderFactory.createEmptyBorder());
            this.lblTitle.setHorizontalTextPosition(0);
            this.lblTitle.setVerticalTextPosition(0);
            this.lblTitle.setOpaque(false);
            this.lblTitle.setAlignmentX(0.5f);
            this.lblTitle.setForeground(new Color(150, 109, 145));
        }
        return this.lblTitle;
    }
}

