/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.dialog;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class OpenDialogAction
extends AbstractAction {
    protected static final Logger logger = Logger.getLogger(OpenDialogAction.class.getName());
    protected Window parentWindow = null;
    protected JComponent content = null;
    protected JDialog dialog = null;
    protected String dialogTitle = "";

    public OpenDialogAction(JComponent parent, JComponent content) {
        if (parent != null) {
            this.setupParentWindow(parent);
        }
        this.content = content;
        this.setupDialog();
    }

    public OpenDialogAction(Window parentWindow, JComponent content) {
        this.parentWindow = parentWindow;
        this.content = content;
        this.setupDialog();
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.setupDialog();
        } else {
            this.dialog.setTitle(this.dialogTitle);
        }
        if (this.parentWindow != null) {
            Point screenLoc = this.parentWindow.getLocationOnScreen();
            this.dialog.setLocation(screenLoc.x + 20, screenLoc.y + 20);
        } else {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            int x = (screenSize.width - this.dialog.getWidth()) / 2;
            int y = (screenSize.height - this.dialog.getHeight()) / 2;
            this.dialog.setLocation(x, y);
        }
        this.dialog.setVisible(true);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    protected void setupParentWindow(JComponent parent) {
        if (parent == null) {
            logger.finer("Parent window is null since parent component is null !");
            this.parentWindow = null;
            return;
        }
        this.parentWindow = SwingUtilities.getWindowAncestor(parent);
        if (this.parentWindow != null) {
            logger.finer("Parent container window found is of type: " + this.parentWindow.getClass().getName());
        }
    }

    protected void setupDialog() {
        if (this.parentWindow == null) {
            this.setupParentWindow(this.content);
        }
        this.dialog = new JDialog(this.parentWindow);
        this.dialog.getContentPane().add(this.content);
        this.dialog.setTitle(this.dialogTitle);
        this.dialog.setModal(true);
        this.dialog.setSize(500, 300);
        this.dialog.setResizable(false);
    }
}

