/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class JRoundedPanel
extends JPanel {
    public static final Color LIGHT_BLUE_COLOR = new Color(236, 243, 250);
    private boolean gradientBackground = false;
    private Color borderColor = Color.LIGHT_GRAY;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.gradientBackground) {
            Color color1 = Color.WHITE;
            Color color2 = new Color(229, 233, 238);
            GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 0.0f, h, color2);
            g2d.setPaint(gp);
            g2d.fillRoundRect(0, 0, w, h, 15, 15);
        }
        g2d.setPaint(this.borderColor);
        g2d.drawRoundRect(0, 0, w, h, 15, 15);
    }

    public boolean isGradientBackground() {
        return this.gradientBackground;
    }

    public void setGradientBackground(boolean gradientBackground) {
        this.gradientBackground = gradientBackground;
        this.repaint();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.repaint();
    }
}

