/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JSplitPaneNoDivider
extends JSplitPane {
    private final int dividerDragOffset = 4;
    private boolean drawDividerLine = false;

    public JSplitPaneNoDivider() {
        this.setDividerSize(7);
        this.setContinuousLayout(true);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        Rectangle bounds = divider.getBounds();
        int dividerDragSize = 9;
        if (this.orientation == 1) {
            bounds.x -= 4;
            bounds.width = dividerDragSize;
        } else {
            bounds.y -= 4;
            bounds.height = dividerDragSize;
        }
        divider.setBounds(bounds);
    }

    @Override
    public void updateUI() {
        this.setUI(new SplitPaneWithZeroSizeDividerUI());
        this.revalidate();
    }

    public void setDrawDividerLine(boolean drawDividerLine) {
        this.drawDividerLine = drawDividerLine;
    }

    public boolean isDrawDividerLine() {
        return this.drawDividerLine;
    }

    private class SplitPaneWithZeroSizeDividerUI
    extends BasicSplitPaneUI {
        private SplitPaneWithZeroSizeDividerUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new ZeroSizeDivider(this);
        }
    }

    private class ZeroSizeDivider
    extends BasicSplitPaneDivider {
        public ZeroSizeDivider(BasicSplitPaneUI ui) {
            super(ui);
            super.setBorder(null);
            this.setBackground(UIManager.getColor("controlShadow"));
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics g) {
            if (JSplitPaneNoDivider.this.drawDividerLine) {
                g.setColor(this.getBackground());
                if (this.orientation == 1) {
                    g.drawLine(4, 0, 4, this.getHeight() - 1);
                } else {
                    g.drawLine(0, 4, this.getWidth() - 1, 4);
                }
            }
        }

        @Override
        protected void dragDividerTo(int location) {
            super.dragDividerTo(location + 4);
        }

        @Override
        protected void finishDraggingTo(int location) {
            super.finishDraggingTo(location + 4);
        }
    }
}

