/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.tabbedpane;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class CloseableTabComponent
extends JPanel {
    private final JTabbedPane tab;
    private JLabel lbl;
    private JPopupMenu menu;
    private JMenuItem itemClose;
    private JMenuItem itemCloseAll;
    private JMenuItem itemCloseAllButThis;
    private JMenuItem itemCloseLeft;
    private JMenuItem itemCloseRight;
    private boolean hideWhenLastClosed = false;

    public CloseableTabComponent(JTabbedPane tab, String title) {
        this.tab = tab;
        this.initialize(title);
    }

    private void initialize(String title) {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setOpaque(false);
        this.lbl = new JLabel(title);
        this.lbl.setBorder(BorderFactory.createEmptyBorder());
        this.add(this.lbl);
        JButton btn = new JButton("x");
        btn.setOpaque(false);
        btn.setBorder(BorderFactory.createEmptyBorder(0, 3, 2, 0));
        btn.setContentAreaFilled(false);
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CloseableTabComponent.this.closeThisTab();
            }
        });
        this.add(btn);
        this.tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.showMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.showMenu(evt);
            }

            protected void showMenu(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    CloseableTabComponent.this.getMenu().show(CloseableTabComponent.this.tab, evt.getX(), evt.getY());
                }
            }
        });
    }

    protected int getTabIndex() {
        for (int index = 0; index < this.tab.getTabCount(); ++index) {
            CloseableTabComponent ctab;
            Component comp = this.tab.getTabComponentAt(index);
            if (!(comp instanceof CloseableTabComponent) || !(ctab = (CloseableTabComponent)comp).equals(this)) continue;
            return index;
        }
        return -1;
    }

    protected JPopupMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.menu.add(this.getItemClose());
            this.menu.add(this.getItemCloseAll());
            this.menu.add(this.getItemCloseAllButThis());
            this.menu.add(this.getItemCloseLeft());
            this.menu.add(this.getItemCloseRight());
        }
        return this.menu;
    }

    protected JMenuItem getItemClose() {
        if (this.itemClose == null) {
            this.itemClose = new JMenuItem();
            this.itemClose.setText("Close");
            this.itemClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloseableTabComponent.this.closeThisTab();
                }
            });
        }
        return this.itemClose;
    }

    protected JMenuItem getItemCloseAll() {
        if (this.itemCloseAll == null) {
            this.itemCloseAll = new JMenuItem();
            this.itemCloseAll.setText("Close all");
            this.itemCloseAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloseableTabComponent.this.closeAllTabs();
                }
            });
        }
        return this.itemCloseAll;
    }

    protected JMenuItem getItemCloseAllButThis() {
        if (this.itemCloseAllButThis == null) {
            this.itemCloseAllButThis = new JMenuItem();
            this.itemCloseAllButThis.setText("Close all but this");
            this.itemCloseAllButThis.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloseableTabComponent.this.closeAllButThis();
                }
            });
        }
        return this.itemCloseAllButThis;
    }

    protected JMenuItem getItemCloseLeft() {
        if (this.itemCloseLeft == null) {
            this.itemCloseLeft = new JMenuItem();
            this.itemCloseLeft.setText("Close left");
            this.itemCloseLeft.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CloseableTabComponent.this.closeLeft();
                }
            });
        }
        return this.itemCloseLeft;
    }

    protected JMenuItem getItemCloseRight() {
        if (this.itemCloseRight == null) {
            this.itemCloseRight = new JMenuItem();
            this.itemCloseRight.setText("Close right");
            this.itemCloseRight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CloseableTabComponent.this.closeRight();
                }
            });
        }
        return this.itemCloseRight;
    }

    protected void closeRight() {
        while (this.tab.getTabCount() - 1 > this.tab.getSelectedIndex()) {
            this.tab.removeTabAt(this.tab.getTabCount() - 1);
        }
        this.checkLastTab();
    }

    protected void closeLeft() {
        while (this.tab.getSelectedIndex() > 0) {
            this.tab.removeTabAt(0);
        }
        this.checkLastTab();
    }

    protected void closeAllButThis() {
        this.closeLeft();
        this.closeRight();
    }

    protected void closeThisTab() {
        int thisIndex = this.getTabIndex();
        if (thisIndex < 0) {
            return;
        }
        this.tab.removeTabAt(thisIndex);
        this.checkLastTab();
    }

    protected void closeAllTabs() {
        while (this.tab.getTabCount() > 0) {
            this.tab.removeTabAt(0);
        }
        this.checkLastTab();
    }

    protected void checkLastTab() {
        if (this.tab.getTabCount() == 0 && this.hideWhenLastClosed) {
            this.tab.setVisible(false);
        }
    }

    public void setTitle(String title) {
        this.lbl.setText(title);
    }

    public String getTitle() {
        return this.lbl.getText();
    }

    public void setHideWhenLastClosed(boolean hideWhenLastClosed) {
        this.hideWhenLastClosed = hideWhenLastClosed;
    }

    public boolean isHideWhenLastClosed() {
        return this.hideWhenLastClosed;
    }
}

