/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.tabbedpane;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class JTabbedPaneNoContentSeparator
extends JTabbedPane {
    public JTabbedPaneNoContentSeparator() {
        this.initialize();
    }

    private void initialize() {
        this.putClientProperty("JTabbedPane.showContentSeparator", false);
    }

    @Override
    public void addTab(String title, Component comp) {
        WrapperContainer container = new WrapperContainer(comp);
        super.addTab(title, container);
    }

    public Component getWrappedSelectedComponent() {
        Component comp = super.getSelectedComponent();
        if (comp instanceof WrapperContainer) {
            WrapperContainer container = (WrapperContainer)comp;
            return container.getWrappedComponent();
        }
        return comp;
    }

    public class WrapperContainer
    extends JPanel {
        private final Component comp;

        public WrapperContainer(Component comp) {
            this.comp = comp;
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 0, 5, 0);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.add(this.comp, gbc);
            this.setOpaque(true);
            this.setBackground(JTabbedPaneNoContentSeparator.this.getBackground());
        }

        public Component getWrappedComponent() {
            return this.comp;
        }
    }
}

