/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.table;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import net.hironico.common.swing.table.FilterableTableHeaderRenderer;
import net.hironico.common.swing.table.ResizeColumnListener;
import net.hironico.common.swing.table.TableColumnAdjuster;
import net.hironico.common.swing.table.TableHeaderPopupMenu;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.sort.TableSortController;

public class FilterableTable
extends JXTable {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, String> filters = new HashMap<Integer, String>();
    private TableHeaderPopupMenu headerPopupMenu = null;
    private JMenuItem itemFilter = null;
    private JMenuItem itemClearAllFilters = null;
    private JMenuItem itemClearFilter = null;
    private JMenuItem itemPackAllColums = null;
    private JMenuItem itemPackColumn = null;
    private final TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster((JTable)((Object)this));

    public FilterableTable() {
        this.initialize();
    }

    protected void applyAllFilters() {
        try {
            ArrayList filterList = new ArrayList();
            for (Map.Entry<Integer, String> entry : this.filters.entrySet()) {
                Integer col = entry.getKey();
                String regExp = entry.getValue();
                RowFilter rf = RowFilter.regexFilter(regExp, col);
                filterList.add(rf);
            }
            TableSortController rowSorter = (TableSortController)this.getRowSorter();
            RowFilter andFilter = RowFilter.andFilter(filterList);
            rowSorter.setRowFilter(andFilter);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.adaptFilteredColumnNames();
    }

    public void clearAllFilters() {
        this.filters.clear();
        this.applyAllFilters();
    }

    public void applyFilter(String regExp, int column) {
        this.filters.put(column, regExp);
        this.applyAllFilters();
    }

    public void clearFilter(int column) {
        this.filters.remove(column);
        this.applyAllFilters();
    }

    public boolean isFiltered(int col) {
        String filter = this.filters.get(col);
        return filter != null && !"".equals(filter);
    }

    protected String getFilteredColumnName(int col) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        Object title = model.getColumnName(col);
        if (this.isFiltered(col)) {
            if (!((String)title).endsWith("(*)")) {
                title = (String)title + "(*)";
            }
        } else {
            title = ((String)title).replaceAll("\\(\\*\\)", "");
        }
        return title;
    }

    protected void adaptFilteredColumnNames() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        Object[] names = new String[model.getColumnCount()];
        for (int i = 0; i < model.getColumnCount(); ++i) {
            names[i] = this.getFilteredColumnName(i);
        }
        model.setColumnIdentifiers(names);
    }

    protected void initialize() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setAutoResizeMode(0);
        this.setAutoCreateRowSorter(true);
        this.setColumnControlVisible(true);
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() >= 2) {
                    TableHeaderPopupMenu menu = FilterableTable.this.getHeaderPopupMenu();
                    int col = FilterableTable.this.columnAtPoint(evt.getPoint());
                    menu.show(evt.getComponent(), evt.getX(), evt.getY(), col);
                }
            }
        };
        new ResizeColumnListener((JTable)((Object)this), this.tableColumnAdjuster);
        TableCellRenderer renderer = this.getTableHeader().getDefaultRenderer();
        FilterableTableHeaderRenderer headerRenderer = new FilterableTableHeaderRenderer(renderer);
        this.getTableHeader().setDefaultRenderer(headerRenderer);
        this.getTableHeader().addMouseListener(adapter);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 80 && e.getModifiersEx() == 128) {
                    FilterableTable.this.tableColumnAdjuster.adjustColumns();
                }
            }
        });
    }

    protected TableHeaderPopupMenu getHeaderPopupMenu() {
        if (this.headerPopupMenu == null) {
            this.headerPopupMenu = new TableHeaderPopupMenu();
            this.headerPopupMenu.add(this.getItemFilter());
            this.headerPopupMenu.add(this.getItemClearFilter());
            this.headerPopupMenu.addSeparator();
            this.headerPopupMenu.add(this.getItemClearAllFilters());
            this.headerPopupMenu.addSeparator();
            this.headerPopupMenu.add(this.getItemPackAllColums());
            this.headerPopupMenu.add(this.getItemPackColumn());
        }
        return this.headerPopupMenu;
    }

    protected JMenuItem getItemPackColumn() {
        if (this.itemPackColumn == null) {
            this.itemPackColumn = new JMenuItem();
            this.itemPackColumn.setText("Pack column");
            this.itemPackColumn.addActionListener(evt -> {
                int col = this.getHeaderPopupMenu().getClickedColumn();
                this.tableColumnAdjuster.adjustColumn(col);
            });
        }
        return this.itemPackColumn;
    }

    protected JMenuItem getItemPackAllColums() {
        if (this.itemPackAllColums == null) {
            this.itemPackAllColums = new JMenuItem();
            this.itemPackAllColums.setText("Pack all columns");
            this.itemPackAllColums.addActionListener(evt -> this.tableColumnAdjuster.adjustColumns());
        }
        return this.itemPackAllColums;
    }

    protected JMenuItem getItemClearAllFilters() {
        if (this.itemClearAllFilters == null) {
            this.itemClearAllFilters = new JMenuItem();
            this.itemClearAllFilters.setText("Clear all filters");
            this.itemClearAllFilters.addActionListener(evt -> this.clearAllFilters());
        }
        return this.itemClearAllFilters;
    }

    protected JMenuItem getItemClearFilter() {
        if (this.itemClearFilter == null) {
            this.itemClearFilter = new JMenuItem();
            this.itemClearFilter.setText("Clear filter");
            this.itemClearFilter.addActionListener(evt -> {
                int col = this.getHeaderPopupMenu().getClickedColumn();
                this.clearFilter(col);
            });
        }
        return this.itemClearFilter;
    }

    protected JMenuItem getItemFilter() {
        if (this.itemFilter == null) {
            this.itemFilter = new JMenuItem();
            this.itemFilter.setText("Filter...");
            this.itemFilter.addActionListener(evt -> {
                int col = this.getHeaderPopupMenu().getClickedColumn();
                String columnFilter = this.filters.get(col);
                String newFilter = JOptionPane.showInputDialog(this.getParent(), "Enter column filter:\n(Empty to clear filter)", columnFilter);
                if (newFilter == null) {
                    return;
                }
                this.applyFilter(newFilter, col);
                this.adaptFilteredColumnNames();
                this.tableColumnAdjuster.adjustColumn(col);
            });
        }
        return this.itemFilter;
    }
}

