/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Base64;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class NicoCrypto {
    private static final Logger LOGGER = Logger.getLogger(NicoCrypto.class.getName());
    private Cipher cipher = null;

    public NicoCrypto() {
        try {
            this.cipher = Cipher.getInstance("AES");
        }
        catch (Exception ex) {
            LOGGER.severe("Unable to init Cypher for encryption operations !");
        }
    }

    public static SecretKey load(File keyFile) throws Exception {
        if (keyFile == null || !keyFile.exists()) {
            throw new FileNotFoundException(keyFile.getAbsolutePath() + ": not found.");
        }
        try (FileReader fr = new FileReader(keyFile);){
            SecretKey secretKey;
            try (BufferedReader br = new BufferedReader(fr);){
                StringBuffer content = new StringBuffer();
                String line = br.readLine();
                while (line != null) {
                    content.append(line);
                    line = br.readLine();
                }
                secretKey = NicoCrypto.generate(content.toString());
            }
            return secretKey;
        }
    }

    public static SecretKey generate(String token) {
        byte[] encoded = Base64.getDecoder().decode(token);
        SecretKeySpec spec = new SecretKeySpec(encoded, "AES");
        return spec;
    }

    public static SecretKey generate() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    public static void main(String[] args) throws Exception {
        SecretKey secretKey = NicoCrypto.generate();
        System.out.println("Key format is: " + secretKey.getFormat());
        byte[] encoded = secretKey.getEncoded();
        encoded = Base64.getEncoder().encode(encoded);
        String encodedStr = new String(encoded);
        System.out.println("Encoded key is: " + encodedStr);
        String plainText = "RTkU7Epv6kIgyhd2xigbqQ==";
        System.out.println("Plain Text Before Encryption: " + plainText);
        NicoCrypto crypto = new NicoCrypto();
        String encryptedText = crypto.encrypt(plainText, secretKey);
        System.out.println("Encrypted Text After Encryption: " + encryptedText);
        String decryptedText = crypto.decrypt(encryptedText, secretKey);
        System.out.println("Decrypted Text After Decryption: " + decryptedText);
    }

    public String encrypt(String plainText, SecretKey secretKey) throws Exception {
        if (this.cipher == null) {
            throw new IllegalArgumentException("Cypher not initialized properly. Cannot encrypt.");
        }
        byte[] plainTextByte = plainText.getBytes();
        this.cipher.init(1, secretKey);
        byte[] encryptedByte = this.cipher.doFinal(plainTextByte);
        Base64.Encoder encoder = Base64.getEncoder();
        String encryptedText = encoder.encodeToString(encryptedByte);
        return encryptedText;
    }

    public String decrypt(String encryptedText, SecretKey secretKey) throws Exception {
        if (this.cipher == null) {
            throw new Exception("Cypher not initialized properly. Cannot decrypt.");
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] encryptedTextByte = decoder.decode(encryptedText);
        this.cipher.init(2, secretKey);
        byte[] decryptedByte = this.cipher.doFinal(encryptedTextByte);
        String decryptedText = new String(decryptedByte);
        return decryptedText;
    }
}

