/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.utils;

import java.util.Enumeration;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.hironico.common.utils.LangUtils;

public class StreamUtils {
    public static <T> Collector<T, ?, T> singletonCollector() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() > 1) {
                if (LangUtils.isAllNull(list)) {
                    return null;
                }
                throw new IllegalStateException();
            }
            return list.isEmpty() ? null : list.get(0);
        });
    }

    public static <T> T uncheckCall(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Stream<T> stream(Enumeration<T> enumeration) {
        EnumerationSpliterator<T> spliterator = new EnumerationSpliterator<T>(Long.MAX_VALUE, 16, enumeration);
        return StreamSupport.stream(spliterator, false);
    }

    private static class EnumerationSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Enumeration<T> enumeration;

        public EnumerationSpliterator(long est, int additionalCharacteristics, Enumeration<T> enumeration) {
            super(est, additionalCharacteristics);
            this.enumeration = enumeration;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.enumeration.hasMoreElements()) {
                action.accept(this.enumeration.nextElement());
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            while (this.enumeration.hasMoreElements()) {
                action.accept(this.enumeration.nextElement());
            }
        }
    }
}

