/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.DefaultAttrValue;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.ElementId;
import com.ctc.wstx.util.ElementIdMap;
import com.ctc.wstx.util.PrefixedName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class DTDIdRefsAttr
extends DTDAttribute {
    public DTDIdRefsAttr(PrefixedName name, DefaultAttrValue defValue, int specIndex, boolean nsAware, boolean xml11) {
        super(name, defValue, specIndex, nsAware, xml11);
    }

    @Override
    public DTDAttribute cloneWith(int specIndex) {
        return new DTDIdRefsAttr(this.mName, this.mDefValue, specIndex, this.mCfgNsAware, this.mCfgXml11);
    }

    @Override
    public int getValueType() {
        return 4;
    }

    @Override
    public String validate(DTDValidatorBase v2, char[] cbuf, int start, int end, boolean normalize) throws XMLStreamException {
        while (start < end && WstxInputData.isSpaceChar(cbuf[start])) {
            ++start;
        }
        if (start >= end) {
            return this.reportValidationProblem(v2, "Empty IDREFS value");
        }
        --end;
        while (end > start && WstxInputData.isSpaceChar(cbuf[end])) {
            --end;
        }
        ElementIdMap m4 = v2.getIdMap();
        Location loc = v2.getLocation();
        String idStr = null;
        StringBuilder sb = null;
        while (start <= end) {
            int i2;
            int c2 = cbuf[start];
            if (!WstxInputData.isNameStartChar((char)c2, this.mCfgNsAware, this.mCfgXml11)) {
                return this.reportInvalidChar(v2, (char)c2, "not valid as the first IDREFS character");
            }
            int hash = c2;
            for (i2 = start + 1; i2 <= end && !WstxInputData.isSpaceChar((char)(c2 = cbuf[i2])); ++i2) {
                if (!WstxInputData.isNameChar((char)c2, this.mCfgNsAware, this.mCfgXml11)) {
                    return this.reportInvalidChar(v2, (char)c2, "not valid as an IDREFS character");
                }
                hash = hash * 31 + c2;
            }
            ElementId id = m4.addReferenced(cbuf, start, i2 - start, hash, loc, v2.getElemName(), this.mName);
            start = i2 + 1;
            if (normalize) {
                if (idStr == null) {
                    idStr = id.getId();
                } else {
                    if (sb == null) {
                        sb = new StringBuilder(idStr);
                    }
                    idStr = id.getId();
                    sb.append(' ');
                    sb.append(idStr);
                }
            }
            while (start <= end && WstxInputData.isSpaceChar(cbuf[start])) {
                ++start;
            }
        }
        if (normalize) {
            if (sb != null) {
                idStr = sb.toString();
            }
            return idStr;
        }
        return null;
    }

    @Override
    public void validateDefault(InputProblemReporter rep, boolean normalize) throws XMLStreamException {
        String def = this.validateDefaultNames(rep, normalize);
        if (normalize) {
            this.mDefValue.setValue(def);
        }
    }
}

