/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDValidatorBase;
import com.ctc.wstx.dtd.DefaultAttrValue;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.util.PrefixedName;
import javax.xml.stream.XMLStreamException;

public final class DTDNmTokensAttr
extends DTDAttribute {
    public DTDNmTokensAttr(PrefixedName name, DefaultAttrValue defValue, int specIndex, boolean nsAware, boolean xml11) {
        super(name, defValue, specIndex, nsAware, xml11);
    }

    @Override
    public DTDAttribute cloneWith(int specIndex) {
        return new DTDNmTokensAttr(this.mName, this.mDefValue, specIndex, this.mCfgNsAware, this.mCfgXml11);
    }

    @Override
    public int getValueType() {
        return 9;
    }

    @Override
    public String validate(DTDValidatorBase v2, char[] cbuf, int start, int end, boolean normalize) throws XMLStreamException {
        while (start < end && WstxInputData.isSpaceChar(cbuf[start])) {
            ++start;
        }
        if (start >= end) {
            return this.reportValidationProblem(v2, "Empty NMTOKENS value");
        }
        if (!normalize) {
            while (start < end) {
                char c2 = cbuf[start];
                if (!WstxInputData.isSpaceChar(c2) && !WstxInputData.isNameChar(c2, this.mCfgNsAware, this.mCfgXml11)) {
                    return this.reportInvalidChar(v2, c2, "not valid as NMTOKENS character");
                }
                ++start;
            }
            return null;
        }
        --end;
        while (end > start && WstxInputData.isSpaceChar(cbuf[end])) {
            --end;
        }
        StringBuilder sb = null;
        while (start <= end) {
            char c3;
            int i2;
            for (i2 = start; i2 <= end && !WstxInputData.isSpaceChar(c3 = cbuf[i2]); ++i2) {
                if (WstxInputData.isNameChar(c3, this.mCfgNsAware, this.mCfgXml11)) continue;
                return this.reportInvalidChar(v2, c3, "not valid as an NMTOKENS character");
            }
            if (sb == null) {
                sb = new StringBuilder(end - start + 1);
            } else {
                sb.append(' ');
            }
            sb.append(cbuf, start, i2 - start);
            for (start = i2 + 1; start <= end && WstxInputData.isSpaceChar(cbuf[start]); ++start) {
            }
        }
        return sb == null ? null : sb.toString();
    }

    @Override
    public void validateDefault(InputProblemReporter rep, boolean normalize) throws XMLStreamException {
        String defValue = this.mDefValue.getValue();
        int len = defValue.length();
        StringBuilder sb = null;
        int count = 0;
        int start = 0;
        block0: while (start < len) {
            char c2 = defValue.charAt(start);
            while (WstxInputData.isSpaceChar(c2)) {
                if (++start >= len) break block0;
                c2 = defValue.charAt(start);
            }
            int i2 = start + 1;
            while (++i2 < len && !WstxInputData.isSpaceChar(c2 = defValue.charAt(i2))) {
            }
            ++count;
            String token = defValue.substring(start, i2);
            int illegalIx = WstxInputData.findIllegalNmtokenChar(token, this.mCfgNsAware, this.mCfgXml11);
            if (illegalIx >= 0) {
                this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; character #" + illegalIx + " (" + WstxInputData.getCharDesc(defValue.charAt(illegalIx)) + ") not a valid NMTOKENS character");
            }
            if (normalize) {
                if (sb == null) {
                    sb = new StringBuilder(i2 - start + 32);
                } else {
                    sb.append(' ');
                }
                sb.append(token);
            }
            start = i2 + 1;
        }
        if (count == 0) {
            this.reportValidationProblem(rep, "Invalid default value '" + defValue + "'; empty String is not a valid NMTOKENS value");
            return;
        }
        if (sb != null) {
            this.mDefValue.setValue(sb.toString());
        }
    }
}

