/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.ConcreteType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;

public final class UnionType
extends ConcreteType {
    public final XSDatatypeImpl[] memberTypes;
    private static final long serialVersionUID = 1L;

    public UnionType(String nsUri, String newTypeName, XSDatatype[] memberTypes) throws DatatypeException {
        super(nsUri, newTypeName);
        if (memberTypes.length == 0) {
            throw new DatatypeException(UnionType.localize("BadTypeException.EmptyUnion"));
        }
        XSDatatypeImpl[] m4 = new XSDatatypeImpl[memberTypes.length];
        System.arraycopy(memberTypes, 0, m4, 0, memberTypes.length);
        for (int i2 = 0; i2 < m4.length; ++i2) {
            if (!m4[i2].isFinal(4)) continue;
            throw new DatatypeException(UnionType.localize("BadTypeException.InvalidMemberType", m4[i2].displayName()));
        }
        this.memberTypes = m4;
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    public final String displayName() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return "union";
    }

    @Override
    public boolean isContextDependent() {
        for (int i2 = 0; i2 < this.memberTypes.length; ++i2) {
            if (!this.memberTypes[i2].isContextDependent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getVariety() {
        return 3;
    }

    @Override
    public final int isFacetApplicable(String facetName) {
        if (facetName.equals("pattern") || facetName.equals("enumeration")) {
            return 0;
        }
        return -2;
    }

    @Override
    protected final boolean checkFormat(String content, ValidationContext context) {
        for (int i2 = 0; i2 < this.memberTypes.length; ++i2) {
            if (!this.memberTypes[i2].checkFormat(content, context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object _createValue(String content, ValidationContext context) {
        for (int i2 = 0; i2 < this.memberTypes.length; ++i2) {
            Object o2 = this.memberTypes[i2]._createValue(content, context);
            if (o2 == null) continue;
            return o2;
        }
        return null;
    }

    @Override
    public Class getJavaObjectType() {
        return Object.class;
    }

    @Override
    public String convertToLexicalValue(Object o2, SerializationContext context) {
        for (int i2 = 0; i2 < this.memberTypes.length; ++i2) {
            try {
                return this.memberTypes[i2].convertToLexicalValue(o2, context);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void _checkValid(String content, ValidationContext context) throws DatatypeException {
        if (this.checkFormat(content, context)) {
            return;
        }
        throw new DatatypeException();
    }
}

