/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;

public class Uri {
    private static String utf8 = "UTF-8";
    private static final String HEX_DIGITS = "0123456789abcdef";
    private static String excluded = "<>\"{}|\\^`";

    public static boolean isValid(String s2) {
        return Uri.isValidPercent(s2) && Uri.isValidFragment(s2) && Uri.isValidScheme(s2);
    }

    public static String escapeDisallowedChars(String s2) {
        StringBuffer buf = null;
        int len = s2.length();
        int done = 0;
        while (true) {
            byte[] bytes;
            int i2 = done;
            while (true) {
                if (i2 == len) {
                    if (done != 0) break;
                    return s2;
                }
                if (Uri.isExcluded(s2.charAt(i2))) break;
                ++i2;
            }
            if (buf == null) {
                buf = new StringBuffer();
            }
            if (i2 > done) {
                buf.append(s2.substring(done, i2));
                done = i2;
            }
            if (i2 == len) break;
            ++i2;
            while (i2 < len && Uri.isExcluded(s2.charAt(i2))) {
                ++i2;
            }
            String tem = s2.substring(done, i2);
            try {
                bytes = tem.getBytes(utf8);
            }
            catch (UnsupportedEncodingException e2) {
                utf8 = "UTF8";
                try {
                    bytes = tem.getBytes(utf8);
                }
                catch (UnsupportedEncodingException e22) {
                    return s2;
                }
            }
            for (int j2 = 0; j2 < bytes.length; ++j2) {
                buf.append('%');
                buf.append(HEX_DIGITS.charAt((bytes[j2] & 0xFF) >> 4));
                buf.append(HEX_DIGITS.charAt(bytes[j2] & 0xF));
            }
            done = i2;
        }
        return buf.toString();
    }

    private static boolean isExcluded(char c2) {
        return c2 <= ' ' || c2 >= '\u007f' || excluded.indexOf(c2) >= 0;
    }

    private static boolean isAlpha(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z';
    }

    private static boolean isHexDigit(char c2) {
        return 'a' <= c2 && c2 <= 'f' || 'A' <= c2 && c2 <= 'F' || Uri.isDigit(c2);
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private static boolean isSchemeChar(char c2) {
        return Uri.isAlpha(c2) || Uri.isDigit(c2) || c2 == '+' || c2 == '-' || c2 == '.';
    }

    private static boolean isValidPercent(String s2) {
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (s2.charAt(i2) != '%') continue;
            if (i2 + 2 >= len) {
                return false;
            }
            if (Uri.isHexDigit(s2.charAt(i2 + 1)) && Uri.isHexDigit(s2.charAt(i2 + 2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFragment(String s2) {
        int i2 = s2.indexOf(35);
        return i2 < 0 || s2.indexOf(35, i2 + 1) < 0;
    }

    private static boolean isValidScheme(String s2) {
        if (!Uri.isAbsolute(s2)) {
            return true;
        }
        int i2 = s2.indexOf(58);
        if (i2 == 0 || i2 + 1 == s2.length() || !Uri.isAlpha(s2.charAt(0))) {
            return false;
        }
        while (--i2 > 0) {
            if (Uri.isSchemeChar(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String resolve(String baseUri, String uriReference) {
        if (!Uri.isAbsolute(uriReference) && baseUri != null && Uri.isAbsolute(baseUri)) {
            try {
                return new URL(new URL(baseUri), uriReference).toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uriReference;
    }

    public static boolean hasFragmentId(String uri) {
        return uri.indexOf(35) >= 0;
    }

    public static boolean isAbsolute(String uri) {
        int i2 = uri.indexOf(58);
        if (i2 < 0) {
            return false;
        }
        while (--i2 >= 0) {
            switch (uri.charAt(i2)) {
                case '#': 
                case '/': 
                case '?': {
                    return false;
                }
            }
        }
        return true;
    }
}

