/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.ElementWrappable;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WrapperHandlingDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Set<String> _namesToWrap;
    protected final JavaType _type;
    protected final boolean _caseInsensitive;

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate) {
        this(delegate, null);
    }

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate, Set<String> namesToWrap) {
        super(delegate);
        this._namesToWrap = namesToWrap;
        this._type = delegate.getValueType();
        this._caseInsensitive = delegate.isCaseInsensitive();
    }

    @Override
    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee0) {
        throw new IllegalStateException("Internal error: should never get called");
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType vt = this._type;
        if (vt == null) {
            vt = ctxt.constructType(this._delegatee.handledType());
        }
        JsonDeserializer<?> del = ctxt.handleSecondaryContextualization(this._delegatee, property, vt);
        BeanDeserializerBase newDelegatee = this._verifyDeserType(del);
        Iterator<SettableBeanProperty> it = newDelegatee.properties();
        HashSet<String> unwrappedNames = null;
        while (it.hasNext()) {
            PropertyName wrapperName;
            SettableBeanProperty prop = it.next();
            JavaType type = prop.getType();
            if (!TypeUtil.isIndexedType(type) || (wrapperName = prop.getWrapperName()) != null && wrapperName != PropertyName.NO_NAME) continue;
            if (unwrappedNames == null) {
                unwrappedNames = new HashSet<String>();
            }
            unwrappedNames.add(prop.getName());
            for (PropertyName alias : prop.findAliases(ctxt.getConfig())) {
                unwrappedNames.add(alias.getSimpleName());
            }
        }
        if (unwrappedNames == null) {
            return newDelegatee;
        }
        return new WrapperHandlingDeserializer(newDelegatee, unwrappedNames);
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        this._configureParser(p2);
        return this._delegatee.deserialize(p2, ctxt);
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt, Object intoValue) throws IOException {
        this._configureParser(p2);
        return this._delegatee.deserialize(p2, ctxt, intoValue);
    }

    @Override
    public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        this._configureParser(p2);
        return this._delegatee.deserializeWithType(p2, ctxt, typeDeserializer);
    }

    protected final void _configureParser(JsonParser p2) throws IOException {
        JsonToken t2;
        while (p2 instanceof JsonParserDelegate) {
            p2 = ((JsonParserDelegate)p2).delegate();
        }
        if (p2 instanceof ElementWrappable && this._namesToWrap != null && ((t2 = p2.currentToken()) == JsonToken.START_OBJECT || t2 == JsonToken.START_ARRAY || t2 == JsonToken.FIELD_NAME)) {
            ((ElementWrappable)((Object)p2)).addVirtualWrapping(this._namesToWrap, this._caseInsensitive);
        }
    }

    protected BeanDeserializerBase _verifyDeserType(JsonDeserializer<?> deser) {
        if (!(deser instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + deser.getClass().getName());
        }
        return (BeanDeserializerBase)deser;
    }
}

