/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.typed.Base64Variants;

public class StaxUtil {
    public static <T> T throwAsParseException(XMLStreamException e2, JsonParser p2) throws IOException {
        Throwable t2 = StaxUtil._unwrap(e2);
        throw new JsonParseException(p2, StaxUtil._message(t2, e2), t2);
    }

    public static <T> T throwAsGenerationException(XMLStreamException e2, JsonGenerator g2) throws IOException {
        Throwable t2 = StaxUtil._unwrap(e2);
        throw new JsonGenerationException(StaxUtil._message(t2, e2), t2, g2);
    }

    private static Throwable _unwrap(Throwable t2) {
        while (t2.getCause() != null) {
            t2 = t2.getCause();
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        return t2;
    }

    private static String _message(Throwable t1, Throwable t2) {
        String msg = t1.getMessage();
        if (msg == null) {
            msg = t2.getMessage();
        }
        return msg;
    }

    public static String sanitizeXmlTypeName(String name) {
        StringBuilder sb;
        if (name == null) {
            return null;
        }
        int changes = 0;
        if (name.endsWith("[]")) {
            do {
                name = name.substring(0, name.length() - 2);
                ++changes;
            } while (name.endsWith("[]"));
            sb = new StringBuilder(name);
            if (name.endsWith("s")) {
                sb.append("es");
            } else {
                sb.append('s');
            }
        } else {
            sb = new StringBuilder(name);
        }
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = name.charAt(i2);
            if (c2 > '\u007f' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.' || c2 == '-') continue;
            ++changes;
            if (c2 == '$') {
                sb.setCharAt(i2, '.');
                continue;
            }
            sb.setCharAt(i2, '_');
        }
        if (changes == 0) {
            return name;
        }
        return sb.toString();
    }

    public static org.codehaus.stax2.typed.Base64Variant toStax2Base64Variant(Base64Variant j64b) {
        return Base64Mapper.instance.map(j64b);
    }

    public static XMLInputFactory defaultInputFactory(ClassLoader cl) {
        try {
            return XMLInputFactory.newFactory(XMLInputFactory.class.getName(), cl);
        }
        catch (NoSuchMethodError | FactoryConfigurationError e2) {
            return XMLInputFactory.newInstance();
        }
    }

    public static XMLOutputFactory defaultOutputFactory(ClassLoader cl) {
        try {
            return XMLOutputFactory.newFactory(XMLOutputFactory.class.getName(), cl);
        }
        catch (NoSuchMethodError | FactoryConfigurationError e2) {
            return XMLOutputFactory.newInstance();
        }
    }

    private static class Base64Mapper {
        public static final Base64Mapper instance = new Base64Mapper();
        private final Map<String, org.codehaus.stax2.typed.Base64Variant> j2stax2 = new HashMap<String, org.codehaus.stax2.typed.Base64Variant>();

        private Base64Mapper() {
            this.j2stax2.put(com.fasterxml.jackson.core.Base64Variants.MIME.getName(), Base64Variants.MIME);
            this.j2stax2.put(com.fasterxml.jackson.core.Base64Variants.MIME_NO_LINEFEEDS.getName(), Base64Variants.MIME_NO_LINEFEEDS);
            this.j2stax2.put(com.fasterxml.jackson.core.Base64Variants.MODIFIED_FOR_URL.getName(), Base64Variants.MODIFIED_FOR_URL);
            this.j2stax2.put(com.fasterxml.jackson.core.Base64Variants.PEM.getName(), Base64Variants.PEM);
        }

        public org.codehaus.stax2.typed.Base64Variant map(Base64Variant j64b) {
            org.codehaus.stax2.typed.Base64Variant result = this.j2stax2.get(j64b.getName());
            if (result == null) {
                result = Base64Variants.getDefaultVariant();
            }
            return result;
        }
    }
}

