/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.plaf.basic.BasicHyperlinkUI;

public class FlatHyperlinkUI
extends BasicHyperlinkUI {
    protected Color disabledText;

    public static ComponentUI createUI(JComponent c2) {
        return new FlatHyperlinkUI();
    }

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        this.disabledText = UIManager.getColor("Hyperlink.disabledText");
    }

    @Override
    protected void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
        this.disabledText = null;
    }

    @Override
    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        FlatButtonUI.paintText(g2, b2, textRect, text, b2.isEnabled() ? b2.getForeground() : this.disabledText);
        if (b2.getModel().isRollover()) {
            this.paintUnderline(g2, textRect);
        }
    }

    private void paintUnderline(Graphics g2, Rectangle rect) {
        int descent = g2.getFontMetrics().getDescent();
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
        ((Graphics2D)g2).fill(new Rectangle2D.Float(rect.x, (float)(rect.y + rect.height - descent) + UIScale.scale(1.0f), rect.width, UIScale.scale(1.0f)));
        FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
    }
}

