/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.UIManager;

public class FlatMonthDownIcon
extends FlatAbstractIcon {
    protected final boolean chevron = FlatUIUtils.isChevron(UIManager.getString("Component.arrowType"));
    protected final Color arrowColor = UIManager.getColor("JXMonthView.arrowColor");
    protected final Color disabledArrowColor = UIManager.getColor("JXMonthView.disabledArrowColor");
    private final int direction;

    public FlatMonthDownIcon() {
        this(7);
    }

    protected FlatMonthDownIcon(int direction) {
        super(20, 20, null);
        this.direction = direction;
    }

    @Override
    protected void paintIcon(Component c2, Graphics2D g2) {
        int w2 = this.chevron ? 4 : 5;
        int h2 = this.chevron ? 8 : 9;
        int x2 = Math.round((float)(this.width - w2) / 2.0f);
        int y2 = Math.round((float)(this.height - h2) / 2.0f);
        g2.setColor(c2.isEnabled() ? this.arrowColor : this.disabledArrowColor);
        g2.translate(x2, y2);
        Shape arrowShape = FlatUIUtils.createArrowShape(this.direction, this.chevron, w2, h2);
        if (this.chevron) {
            g2.setStroke(new BasicStroke(1.0f));
            g2.draw(arrowShape);
        } else {
            g2.fill(arrowShape);
        }
        g2.translate(-x2, -y2);
    }
}

