/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class FlatTaskPaneUI
extends BasicTaskPaneUI {
    private Color background;

    public static ComponentUI createUI(JComponent c2) {
        return new FlatTaskPaneUI();
    }

    @Override
    protected void installDefaults() {
        if (this.group.getContentPane() instanceof JComponent) {
            JComponent content = (JComponent)this.group.getContentPane();
            Border contentBorder = content.getBorder();
            if (contentBorder instanceof CompoundBorder && ((CompoundBorder)contentBorder).getOutsideBorder() instanceof BasicTaskPaneUI.ContentPaneBorder && ((CompoundBorder)contentBorder).getInsideBorder() instanceof EmptyBorder) {
                content.setBorder(null);
            }
            this.background = UIManager.getColor("TaskPane.background");
            Color bg = content.getBackground();
            if (bg == null || bg instanceof UIResource) {
                content.setBackground(new Color(this.background.getRGB(), true));
            }
        }
        this.roundHeight = FlatUIUtils.getUIInt("TaskPane.roundHeight", UIManager.getInt("Component.arc"));
        super.installDefaults();
    }

    @Override
    public void uninstallUI(JComponent c2) {
        if (this.group.getContentPane() instanceof JComponent) {
            JComponent content = (JComponent)this.group.getContentPane();
            if (content.getBorder() instanceof FlatContentPaneBorder) {
                content.setBorder(null);
            }
            if (this.background.equals(content.getBackground())) {
                content.setBackground(this.background);
            }
            this.background = null;
        }
        super.uninstallUI(c2);
    }

    @Override
    protected int getTitleHeight(Component c2) {
        return Math.max(super.getTitleHeight(c2), UIScale.scale(this.titleHeight));
    }

    @Override
    protected int getRoundHeight() {
        return UIScale.scale(this.roundHeight);
    }

    @Override
    protected Border createPaneBorder() {
        return new FlatPaneBorder();
    }

    @Override
    protected Border createContentPaneBorder() {
        return new FlatContentPaneBorder(UIManager.getColor("TaskPane.borderColor"), UIManager.getInsets("TaskPane.contentInsets"));
    }

    private class FlatPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        private FlatPaneBorder() {
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
            super.paintBorder(c2, g2, x2, y2, width, height);
            FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
        }

        @Override
        protected void paintTitleBackground(JXTaskPane group, Graphics g2) {
            int width = group.getWidth();
            int height = FlatTaskPaneUI.this.getTitleHeight(group);
            float arc = UIScale.scale((float)FlatTaskPaneUI.this.roundHeight);
            float lineWidth = UIScale.scale(1.0f);
            g2.setColor(group.isSpecial() ? this.specialTitleBackground : this.titleBackgroundGradientStart);
            ((Graphics2D)g2).fill(FlatUIUtils.createRoundRectanglePath(lineWidth, lineWidth, (float)width - lineWidth * 2.0f, (float)height - lineWidth * 2.0f, arc - lineWidth, arc - lineWidth, 0.0f, 0.0f));
            if (this.borderColor != null) {
                g2.setColor(this.borderColor);
                ((Graphics2D)g2).fill(FlatUIUtils.createRoundRectangle(0.0f, 0.0f, width, height, lineWidth, arc, arc, 0.0f, 0.0f));
            }
        }

        @Override
        protected void paintExpandedControls(JXTaskPane group, Graphics g2, int x2, int y2, int width, int height) {
            g2.setColor(this.getPaintColor(group));
            this.paintChevronControls(group, g2, x2, y2, width, height);
        }

        @Override
        protected void paintChevronControls(JXTaskPane group, Graphics g2, int x2, int y2, int width, int height) {
            Graphics2D g22 = (Graphics2D)g2;
            float cw = UIScale.scale(7.0f);
            float ch = UIScale.scale(3.5f);
            int direction = group.isCollapsed() ? 5 : 1;
            Shape arrowShape = FlatUIUtils.createArrowShape(direction, true, cw, ch);
            x2 = group.getComponentOrientation().isLeftToRight() ? group.getWidth() - width - y2 : y2;
            int cx = (int)((float)(x2 + width / 2) - cw / 2.0f);
            int cy = (int)((float)y2 + ((float)(height / 2) - ch));
            float offset = ch + UIScale.scale(1.0f);
            g22.setStroke(new BasicStroke(UIScale.scale(1.0f)));
            g22.translate(cx, cy);
            FlatUIUtils.drawShapePure(g22, arrowShape);
            g22.translate(0.0, offset);
            FlatUIUtils.drawShapePure(g22, arrowShape);
            g22.translate((double)(-cx), -((float)cy + offset));
        }

        @Override
        protected void paintTitle(JXTaskPane group, Graphics g2, Color textColor, int x2, int y2, int width, int height) {
            int titleX = UIScale.scale(3);
            int titleWidth = group.getWidth() - FlatTaskPaneUI.this.getTitleHeight(group) - titleX;
            if (!group.getComponentOrientation().isLeftToRight()) {
                titleX = group.getWidth() - titleX - titleWidth;
            }
            super.paintTitle(group, g2, textColor, titleX, y2, titleWidth, height);
        }

        @Override
        protected void paintFocus(Graphics g2, Color paintColor, int x2, int y2, int width, int height) {
            int sx = UIScale.scale(x2);
            int sy = UIScale.scale(y2);
            int swidth = width - (sx - x2) * 2;
            int sheight = height - (sy - y2) * 2;
            super.paintFocus(g2, paintColor, sx, sy, swidth, sheight);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }
    }

    private static class FlatContentPaneBorder
    extends EmptyBorder {
        Color color;

        FlatContentPaneBorder(Color color, Insets insets) {
            super(insets);
            this.color = color;
            ++this.left;
            ++this.right;
            ++this.bottom;
        }

        @Override
        public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
            if (this.color == null) {
                return;
            }
            Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
            g2.setColor(this.color);
            float lineWidth = UIScale.scale(1.0f);
            Path2D.Float path = new Path2D.Float(0);
            path.append(new Rectangle2D.Float(x2, y2, width, height), false);
            path.append(new Rectangle2D.Float((float)x2 + lineWidth, y2, (float)width - lineWidth * 2.0f, (float)height - lineWidth), false);
            ((Graphics2D)g2).fill(path);
            FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
        }

        @Override
        public Insets getBorderInsets() {
            return new Insets(UIScale.scale(this.top), UIScale.scale(this.left), UIScale.scale(this.bottom), UIScale.scale(this.right));
        }

        @Override
        public Insets getBorderInsets(Component c2, Insets insets) {
            insets.left = UIScale.scale(this.left);
            insets.top = UIScale.scale(this.top);
            insets.right = UIScale.scale(this.right);
            insets.bottom = UIScale.scale(this.bottom);
            return insets;
        }
    }
}

