/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLabelUI;

public class FlatLabelUI
extends BasicLabelUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private static Set<String> tagsUseFontSizeSet;

    public static ComponentUI createUI(JComponent c2) {
        return FlatUIUtils.canUseSharedUI(c2) ? FlatUIUtils.createSharedUI(FlatLabelUI.class, () -> new FlatLabelUI(true)) : new FlatLabelUI(false);
    }

    protected FlatLabelUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        this.installStyle((JLabel)c2);
    }

    @Override
    protected void installDefaults(JLabel c2) {
        super.installDefaults(c2);
        if (!this.defaults_initialized) {
            this.disabledForeground = UIManager.getColor("Label.disabledForeground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(JLabel c2) {
        super.uninstallDefaults(c2);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installComponents(JLabel c2) {
        super.installComponents(c2);
        FlatLabelUI.updateHTMLRenderer(c2, c2.getText(), false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        String name = e2.getPropertyName();
        if (name == "text" || name == "font" || name == "foreground") {
            JLabel label = (JLabel)e2.getSource();
            FlatLabelUI.updateHTMLRenderer(label, label.getText(), true);
        } else if (name.equals("FlatLaf.style") || name.equals("FlatLaf.styleClass")) {
            JLabel label = (JLabel)e2.getSource();
            if (this.shared && FlatStylingSupport.hasStyleProperty(label)) {
                label.updateUI();
            } else {
                this.installStyle(label);
            }
            label.revalidate();
            label.repaint();
        } else {
            super.propertyChange(e2);
        }
    }

    protected void installStyle(JLabel c2) {
        try {
            this.applyStyle(c2, FlatStylingSupport.getResolvedStyle(c2, "Label"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(JLabel c2, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(c2, (String)key, value));
    }

    protected Object applyStyleProperty(JLabel c2, String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, c2, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c2) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c2, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    static void updateHTMLRenderer(JComponent c2, String text, boolean always) {
        if (BasicHTML.isHTMLString(text) && c2.getClientProperty("html.disable") != Boolean.TRUE && FlatLabelUI.needsFontBaseSize(text)) {
            int insertIndex;
            String style = "<style>BASE_SIZE " + c2.getFont().getSize() + "</style>";
            String lowerText = text.toLowerCase();
            int headIndex = lowerText.indexOf("<head>");
            if (headIndex >= 0) {
                insertIndex = headIndex + "<head>".length();
            } else {
                int styleIndex = lowerText.indexOf("<style>");
                if (styleIndex >= 0) {
                    insertIndex = styleIndex;
                } else {
                    style = "<head>" + style + "</head>";
                    insertIndex = "<html>".length();
                }
            }
            text = text.substring(0, insertIndex) + style + text.substring(insertIndex);
        } else if (!always) {
            return;
        }
        BasicHTML.updateRenderer(c2, text);
    }

    private static boolean needsFontBaseSize(String text) {
        if (tagsUseFontSizeSet == null) {
            tagsUseFontSizeSet = new HashSet<String>(Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "code", "kbd", "big", "small", "samp"));
        }
        int textLength = text.length();
        block3: for (int i2 = 6; i2 < textLength - 1; ++i2) {
            if (text.charAt(i2) != '<') continue;
            switch (text.charAt(i2 + 1)) {
                case 'B': 
                case 'C': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'b': 
                case 'c': 
                case 'h': 
                case 'k': 
                case 's': {
                    int tagBegin = i2 + 1;
                    i2 += 2;
                    while (i2 < textLength) {
                        if (!Character.isLetterOrDigit(text.charAt(i2))) {
                            String tag = text.substring(tagBegin, i2).toLowerCase();
                            if (!tagsUseFontSizeSet.contains(tag)) continue block3;
                            return true;
                        }
                        ++i2;
                    }
                    continue block3;
                }
            }
        }
        return false;
    }

    static Graphics createGraphicsHTMLTextYCorrection(Graphics g2, JComponent c2) {
        return c2.getClientProperty("html") != null ? HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)g2) : g2;
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(g2, c2), c2);
    }

    @Override
    protected void paintEnabledText(JLabel l2, Graphics g2, String s2, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l2.getDisplayedMnemonicIndex() : -1;
        g2.setColor(l2.getForeground());
        FlatUIUtils.drawStringUnderlineCharAt(l2, g2, s2, mnemIndex, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l2, Graphics g2, String s2, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l2.getDisplayedMnemonicIndex() : -1;
        g2.setColor(this.disabledForeground);
        FlatUIUtils.drawStringUnderlineCharAt(l2, g2, s2, mnemIndex, textX, textY);
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, UIScale.scale(label.getIconTextGap()));
    }
}

