/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class FlatPanelUI
extends BasicPanelUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    @FlatStylingSupport.Styleable
    protected int arc = -1;
    private final boolean shared;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c2) {
        return FlatUIUtils.canUseSharedUI(c2) ? FlatUIUtils.createSharedUI(FlatPanelUI.class, () -> new FlatPanelUI(true)) : new FlatPanelUI(false);
    }

    protected FlatPanelUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c2) {
        super.installUI(c2);
        c2.addPropertyChangeListener(this);
        this.installStyle((JPanel)c2);
    }

    @Override
    public void uninstallUI(JComponent c2) {
        super.uninstallUI(c2);
        c2.removePropertyChangeListener(this);
        this.oldStyleValues = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e2) {
        switch (e2.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JPanel c2 = (JPanel)e2.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(c2)) {
                    c2.updateUI();
                } else {
                    this.installStyle(c2);
                }
                c2.revalidate();
                c2.repaint();
            }
        }
    }

    protected void installStyle(JPanel c2) {
        try {
            this.applyStyle(c2, FlatStylingSupport.getResolvedStyle(c2, "Panel"));
        }
        catch (RuntimeException ex) {
            LoggingFacade.INSTANCE.logSevere(null, ex);
        }
    }

    protected void applyStyle(JPanel c2, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(c2, (String)key, value));
    }

    protected Object applyStyleProperty(JPanel c2, String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, c2, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c2) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c2, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        if (c2.isOpaque()) {
            int arc;
            int width = c2.getWidth();
            int height = c2.getHeight();
            int n2 = this.arc >= 0 ? this.arc : (arc = c2.getBorder() instanceof FlatLineBorder ? ((FlatLineBorder)c2.getBorder()).getArc() : 0);
            if (arc > 0) {
                FlatUIUtils.paintParentBackground(g2, c2);
            }
            g2.setColor(c2.getBackground());
            if (arc > 0) {
                Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
                FlatUIUtils.paintComponentBackground((Graphics2D)g2, 0, 0, width, height, 0.0f, UIScale.scale(arc));
                FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
            } else {
                g2.fillRect(0, 0, width, height);
            }
        }
        this.paint(g2, c2);
    }
}

