/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FilterEffects;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JComponent;

public class BufferPainter {
    public static final boolean DEBUG_PAINT = false;

    public static void paintElement(Graphics2D g2, RenderableElement element) throws SVGException {
        if (element.cachedMask != null || element.filter != null && !element.filter.filterEffects.isEmpty()) {
            BufferPainter.renderElement(g2, element);
        } else {
            element.doRender(g2);
        }
    }

    private static float getTransformScale(Point2D.Float origin, Point2D.Float testPoint, AffineTransform transform) {
        transform.transform(testPoint, testPoint);
        float dx = testPoint.x - origin.x;
        float dy = testPoint.y - origin.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    private static void renderElement(Graphics2D g2, RenderableElement element) throws SVGException {
        BufferedImage elementImage;
        AffineTransform transform = g2.getTransform();
        Graphics2D gg = (Graphics2D)g2.create();
        Rectangle elementBounds = element.getBoundingBox().getBounds();
        Rectangle transformedBounds = transform.createTransformedShape(elementBounds).getBounds();
        Rectangle dstBounds = new Rectangle(transformedBounds);
        JComponent observer = element.diagram.getCurrentRenderTarget();
        Cache cache = element.getBufferCache();
        if (cache == null || observer == null || !cache.isCompatible(transform)) {
            elementImage = BufferPainter.renderToBuffer(gg, element, transform, transformedBounds, dstBounds);
            if (observer != null) {
                Cache cacheEntry = new Cache(elementImage, new Rectangle(dstBounds), transform);
                element.setBufferImage(cacheEntry);
            }
        } else {
            elementImage = cache.img;
            dstBounds.setBounds(cache.getBoundsForTransform(transform));
        }
        gg.setTransform(new AffineTransform());
        gg.drawImage((Image)elementImage, dstBounds.x, dstBounds.y, observer);
        gg.dispose();
    }

    private static BufferedImage renderToBuffer(Graphics2D gg, RenderableElement element, AffineTransform transform, Rectangle transformedBounds, Rectangle dstBounds) throws SVGException {
        Point2D.Float origin = new Point2D.Float(0.0f, 0.0f);
        transform.transform(origin, origin);
        Point2D.Float testPoint = new Point2D.Float(1.0f, 0.0f);
        float xScale = BufferPainter.getTransformScale(origin, testPoint, transform);
        testPoint.setLocation(0.0f, 1.0f);
        float yScale = BufferPainter.getTransformScale(origin, testPoint, transform);
        List filterOps = element.filter == null ? Collections.emptyList() : element.filter.filterEffects.stream().flatMap(f2 -> f2.getOperations(dstBounds, xScale, yScale).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        for (Object filterOp : filterOps) {
            int right = Math.max(dstBounds.x + dstBounds.width, ((FilterEffects.FilterOp)filterOp).requiredImageBounds.x + ((FilterEffects.FilterOp)filterOp).requiredImageBounds.width);
            int bottom = Math.max(dstBounds.y + dstBounds.height, ((FilterEffects.FilterOp)filterOp).requiredImageBounds.y + ((FilterEffects.FilterOp)filterOp).requiredImageBounds.height);
            dstBounds.x = Math.min(dstBounds.x, ((FilterEffects.FilterOp)filterOp).requiredImageBounds.x);
            dstBounds.y = Math.min(dstBounds.y, ((FilterEffects.FilterOp)filterOp).requiredImageBounds.y);
            dstBounds.width = right - dstBounds.x;
            dstBounds.height = bottom - dstBounds.y;
        }
        BufferedImage elementImage = BufferPainter.paintToBuffer(gg, transform, dstBounds, transformedBounds, element, null, true);
        for (FilterEffects.FilterOp filterOp : filterOps) {
            elementImage = filterOp.op.filter(elementImage, null);
        }
        if (element.cachedMask != null) {
            BufferedImage maskImage = BufferPainter.paintToBuffer(gg, transform, dstBounds, transformedBounds, element.cachedMask, Color.BLACK, false);
            Graphics2D elementGraphics = (Graphics2D)elementImage.getGraphics();
            elementGraphics.setRenderingHints(gg.getRenderingHints());
            elementGraphics.setComposite(element.cachedMask.createMaskComposite());
            elementGraphics.drawImage((Image)maskImage, 0, 0, element.diagram.getCurrentRenderTarget());
            elementGraphics.dispose();
        }
        return elementImage;
    }

    public static BufferedImage paintToBuffer(Graphics2D g2, AffineTransform transform, Rectangle srcBounds, RenderableElement element, Color bgColor) throws SVGException {
        return BufferPainter.paintToBuffer(g2, transform, srcBounds, srcBounds, element, bgColor, false);
    }

    public static BufferedImage paintToBuffer(Graphics2D g2, AffineTransform transform, Rectangle dstBounds, Rectangle srcBounds, RenderableElement element, Color bgColor, boolean preMultiplied) throws SVGException {
        int type = preMultiplied ? 3 : 2;
        BufferedImage img = new BufferedImage(dstBounds.width, dstBounds.height, type);
        Graphics2D imgGraphics = (Graphics2D)img.getGraphics();
        if (g2 != null) {
            imgGraphics.setRenderingHints(g2.getRenderingHints());
        } else if (bgColor != null) {
            imgGraphics.setColor(bgColor);
            imgGraphics.fillRect(0, 0, img.getWidth(), img.getHeight());
        }
        int xRelative = srcBounds.x - dstBounds.x;
        int yRelative = srcBounds.y - dstBounds.y;
        imgGraphics.translate(xRelative, yRelative);
        imgGraphics.clipRect(0, 0, srcBounds.width, srcBounds.height);
        imgGraphics.translate(-srcBounds.x, -srcBounds.y);
        imgGraphics.transform(transform);
        element.doRender(imgGraphics);
        imgGraphics.dispose();
        return img;
    }

    public static class Cache {
        private final BufferedImage img;
        private final Rectangle bounds;
        private final AffineTransform transform;

        public Cache(BufferedImage img, Rectangle bounds, AffineTransform transform) {
            this.img = img;
            this.bounds = bounds;
            this.transform = transform;
        }

        boolean isCompatible(AffineTransform tx) {
            return tx.getScaleX() == this.transform.getScaleX() && tx.getScaleY() == this.transform.getScaleY() && tx.getShearX() == this.transform.getShearX() && tx.getShearY() == this.transform.getShearY();
        }

        Rectangle getBoundsForTransform(AffineTransform tx) {
            double dx = tx.getTranslateX() - this.transform.getTranslateX();
            double dy = tx.getTranslateY() - this.transform.getTranslateY();
            return new Rectangle((int)((double)this.bounds.x + dx), (int)((double)this.bounds.y + dy), this.bounds.width, this.bounds.height);
        }
    }
}

