/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FilterEffects;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Rectangle;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Arrays;
import java.util.List;

public class FeGaussianBlur
extends FilterEffects {
    public static final String TAG_NAME = "fegaussianblur";
    private float[] stdDeviation;
    private float xCurrent;
    private float yCurrent;
    private ConvolveOp xBlur;
    private ConvolveOp yBlur;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute sty = new StyleAttribute();
        this.stdDeviation = new float[]{0.0f};
        if (this.getPres(sty.setName("stdDeviation"))) {
            this.stdDeviation = sty.getFloatList();
        }
        this.xBlur = null;
        this.yBlur = null;
    }

    @Override
    public List<FilterEffects.FilterOp> getOperations(Rectangle inputBounds, float xScale, float yScale) {
        float xSigma = xScale * this.stdDeviation[0];
        float ySigma = yScale * this.stdDeviation[Math.min(this.stdDeviation.length - 1, 1)];
        return Arrays.asList(xSigma > 0.0f ? this.getGaussianBlurFilter(inputBounds, xSigma, true) : null, ySigma > 0.0f ? this.getGaussianBlurFilter(inputBounds, ySigma, false) : null);
    }

    public FilterEffects.FilterOp getGaussianBlurFilter(Rectangle inputBounds, float sigma, boolean horizontal) {
        int multiplier = 2;
        float radius = 2.0f * sigma + 1.0f;
        int size = (int)Math.ceil(radius * (float)multiplier) + 1;
        if (horizontal && (this.xBlur == null || this.xCurrent != sigma) || !horizontal && (this.yBlur == null || this.yCurrent != sigma)) {
            int i2;
            if (horizontal) {
                this.xCurrent = sigma;
            } else {
                this.yCurrent = sigma;
            }
            float[] data = new float[size];
            float radius2 = radius * radius;
            float twoSigmaSquare = 2.0f * sigma * sigma;
            float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
            float total = 0.0f;
            float middle = (float)size / 2.0f;
            for (i2 = 0; i2 < size; ++i2) {
                float distance = middle - (float)i2;
                data[i2] = (distance *= distance) > radius2 ? 0.0f : (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
                total += data[i2];
            }
            i2 = 0;
            while (i2 < data.length) {
                int n2 = i2++;
                data[n2] = data[n2] / total;
            }
            if (horizontal) {
                this.xBlur = new ConvolveOp(new Kernel(size, 1, data), 1, null);
            } else {
                this.yBlur = new ConvolveOp(new Kernel(1, size, data), 1, null);
            }
        }
        Rectangle dstBounds = new Rectangle(inputBounds);
        if (horizontal) {
            dstBounds.grow(size, 0);
        } else {
            dstBounds.grow(0, size);
        }
        return new FilterEffects.FilterOp(horizontal ? this.xBlur : this.yBlur, dstBounds);
    }
}

