/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Group;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Marker
extends Group {
    public static final String TAG_NAME = "marker";
    AffineTransform viewXform;
    AffineTransform markerXform;
    Rectangle2D viewBox;
    float refX;
    float refY;
    float markerWidth = 1.0f;
    float markerHeight = 1.0f;
    float orient = Float.NaN;
    boolean markerUnitsStrokeWidth = true;
    public static final int MARKER_START = 0;
    public static final int MARKER_MID = 1;
    public static final int MARKER_END = 2;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        String markerUnits;
        super.build();
        StyleAttribute sty = new StyleAttribute();
        if (this.getPres(sty.setName("refX"))) {
            this.refX = sty.getFloatValueWithUnits();
        }
        if (this.getPres(sty.setName("refY"))) {
            this.refY = sty.getFloatValueWithUnits();
        }
        if (this.getPres(sty.setName("markerWidth"))) {
            this.markerWidth = sty.getFloatValueWithUnits();
        }
        if (this.getPres(sty.setName("markerHeight"))) {
            this.markerHeight = sty.getFloatValueWithUnits();
        }
        if (this.getPres(sty.setName("orient"))) {
            this.orient = "auto".equals(sty.getStringValue()) ? Float.NaN : sty.getFloatValue();
        }
        if (this.getPres(sty.setName("viewBox"))) {
            float[] dim = sty.getFloatList();
            this.viewBox = new Rectangle2D.Float(dim[0], dim[1], dim[2], dim[3]);
        }
        if (this.viewBox == null) {
            this.viewBox = new Rectangle(0, 0, 1, 1);
        }
        if (this.getPres(sty.setName("markerUnits")) && (markerUnits = sty.getStringValue()) != null && markerUnits.equals("userSpaceOnUse")) {
            this.markerUnitsStrokeWidth = false;
        }
        this.viewXform = new AffineTransform();
        this.viewXform.scale(1.0 / this.viewBox.getWidth(), 1.0 / this.viewBox.getHeight());
        this.viewXform.translate(-this.viewBox.getX(), -this.viewBox.getY());
        this.markerXform = new AffineTransform();
        this.markerXform.scale(this.markerWidth, this.markerHeight);
        this.markerXform.concatenate(this.viewXform);
        this.markerXform.translate(-this.refX, -this.refY);
    }

    @Override
    protected boolean outsideClip(Graphics2D g2) throws SVGException {
        Shape clip = g2.getClip();
        Rectangle2D rect = super.getBoundingBox();
        return clip != null && !clip.intersects(rect);
    }

    @Override
    protected void doRender(Graphics2D g2) throws SVGException {
        AffineTransform oldXform = g2.getTransform();
        g2.transform(this.markerXform);
        super.doRender(g2);
        g2.setTransform(oldXform);
    }

    public void render(Graphics2D g2, MarkerPos pos, float strokeWidth) throws SVGException {
        AffineTransform cacheXform = g2.getTransform();
        g2.translate(pos.x, pos.y);
        if (this.markerUnitsStrokeWidth) {
            g2.scale(strokeWidth, strokeWidth);
        }
        g2.rotate(Math.atan2(pos.dy, pos.dx));
        g2.transform(this.markerXform);
        super.doRender(g2);
        g2.setTransform(cacheXform);
    }

    @Override
    public Shape getShape() {
        Shape shape = super.getShape();
        return this.markerXform.createTransformedShape(shape);
    }

    @Override
    public Rectangle2D getBoundingBox() throws SVGException {
        Rectangle2D rect = super.getBoundingBox();
        return this.markerXform.createTransformedShape(rect).getBounds2D();
    }

    @Override
    public boolean updateTime(double curTime) throws SVGException {
        boolean changeState = super.updateTime(curTime);
        this.build();
        return changeState;
    }

    public static class MarkerLayout {
        private ArrayList<MarkerPos> markerList = new ArrayList();
        boolean started = false;

        public void layout(Shape shape) {
            double px = 0.0;
            double py = 0.0;
            double[] coords = new double[6];
            PathIterator it = shape.getPathIterator(null);
            while (!it.isDone()) {
                switch (it.currentSegment(coords)) {
                    case 0: {
                        px = coords[0];
                        py = coords[1];
                        this.started = false;
                        break;
                    }
                    case 4: {
                        this.started = false;
                        break;
                    }
                    case 1: {
                        double x2 = coords[0];
                        double y2 = coords[1];
                        this.markerIn(px, py, x2 - px, y2 - py);
                        this.markerOut(x2, y2, x2 - px, y2 - py);
                        px = x2;
                        py = y2;
                        break;
                    }
                    case 2: {
                        double k0x = coords[0];
                        double k0y = coords[1];
                        double x3 = coords[2];
                        double y3 = coords[3];
                        if (px != k0x || py != k0y) {
                            this.markerIn(px, py, k0x - px, k0y - py);
                        } else {
                            this.markerIn(px, py, x3 - px, y3 - py);
                        }
                        if (x3 != k0x || y3 != k0y) {
                            this.markerOut(x3, y3, x3 - k0x, y3 - k0y);
                        } else {
                            this.markerOut(x3, y3, x3 - px, y3 - py);
                        }
                        this.markerIn(px, py, k0x - px, k0y - py);
                        this.markerOut(x3, y3, x3 - k0x, y3 - k0y);
                        px = x3;
                        py = y3;
                        break;
                    }
                    case 3: {
                        double k0x = coords[0];
                        double k0y = coords[1];
                        double k1x = coords[2];
                        double k1y = coords[3];
                        double x4 = coords[4];
                        double y4 = coords[5];
                        if (px != k0x || py != k0y) {
                            this.markerIn(px, py, k0x - px, k0y - py);
                        } else if (px != k1x || py != k1y) {
                            this.markerIn(px, py, k1x - px, k1y - py);
                        } else {
                            this.markerIn(px, py, x4 - px, y4 - py);
                        }
                        if (x4 != k1x || y4 != k1y) {
                            this.markerOut(x4, y4, x4 - k1x, y4 - k1y);
                        } else if (x4 != k0x || y4 != k0y) {
                            this.markerOut(x4, y4, x4 - k0x, y4 - k0y);
                        } else {
                            this.markerOut(x4, y4, x4 - px, y4 - py);
                        }
                        px = x4;
                        py = y4;
                        break;
                    }
                }
                it.next();
            }
            for (int i2 = 1; i2 < this.markerList.size(); ++i2) {
                MarkerPos prev = this.markerList.get(i2 - 1);
                MarkerPos cur = this.markerList.get(i2);
                if (cur.type != 0) continue;
                prev.type = 2;
            }
            MarkerPos last = this.markerList.get(this.markerList.size() - 1);
            last.type = 2;
        }

        private void markerIn(double x2, double y2, double dx, double dy) {
            if (!this.started) {
                this.started = true;
                this.markerList.add(new MarkerPos(0, x2, y2, dx, dy));
            }
        }

        private void markerOut(double x2, double y2, double dx, double dy) {
            this.markerList.add(new MarkerPos(1, x2, y2, dx, dy));
        }

        public ArrayList<MarkerPos> getMarkerList() {
            return this.markerList;
        }
    }

    public static class MarkerPos {
        int type;
        double x;
        double y;
        double dx;
        double dy;

        public MarkerPos(int type, double x2, double y2, double dx, double dy) {
            this.type = type;
            this.x = x2;
            this.y = y2;
            this.dx = dx;
            this.dy = dy;
        }
    }
}

