/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.pattern;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PatternPaintContext
implements PaintContext {
    BufferedImage source;
    Rectangle deviceBounds;
    AffineTransform xform;
    int sourceWidth;
    int sourceHeight;
    BufferedImage buf;

    public PatternPaintContext(BufferedImage source, Rectangle deviceBounds, AffineTransform userXform, AffineTransform distortXform) {
        this.source = source;
        this.deviceBounds = deviceBounds;
        try {
            this.xform = distortXform.createInverse();
            this.xform.concatenate(userXform.createInverse());
        }
        catch (Exception e2) {
            Logger.getLogger("svgSalamandeLogger").log(Level.WARNING, null, e2);
        }
        this.sourceWidth = source.getWidth();
        this.sourceHeight = source.getHeight();
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public Raster getRaster(int x2, int y2, int w2, int h2) {
        if (this.buf == null || this.buf.getWidth() != w2 || this.buf.getHeight() != h2) {
            this.buf = new BufferedImage(w2, h2, this.source.getType());
        }
        Point2D.Float srcPt = new Point2D.Float();
        Point2D.Float destPt = new Point2D.Float();
        for (int j2 = 0; j2 < h2; ++j2) {
            for (int i2 = 0; i2 < w2; ++i2) {
                int jj;
                destPt.setLocation(i2 + x2, j2 + y2);
                this.xform.transform(destPt, srcPt);
                int ii = (int)srcPt.x % this.sourceWidth;
                if (ii < 0) {
                    ii += this.sourceWidth;
                }
                if ((jj = (int)srcPt.y % this.sourceHeight) < 0) {
                    jj += this.sourceHeight;
                }
                this.buf.setRGB(i2, j2, this.source.getRGB(ii, jj));
            }
        }
        return this.buf.getData();
    }

    public static void main(String[] argv) {
        int i2 = -4;
        System.err.println("Hello " + i2 % 4);
    }
}

