/*
 * Decompiled with CFR 0.152.
 */
package commonj.sdo.impl;

import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;

public abstract class HelperProvider {
    static HelperProvider INSTANCE = HelperProvider.getHelperProviderImpl();
    static HelperContext defaultContext = new DefaultHelperContext();

    static HelperProvider getHelperProviderImpl() {
        try {
            return (HelperProvider)Class.forName("commonj.sdo.impl.HelperProviderImpl").newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    HelperProvider() {
    }

    public static CopyHelper getCopyHelper() {
        return INSTANCE.copyHelper();
    }

    public static DataFactory getDataFactory() {
        return INSTANCE.dataFactory();
    }

    public static DataHelper getDataHelper() {
        return INSTANCE.dataHelper();
    }

    public static EqualityHelper getEqualityHelper() {
        return INSTANCE.equalityHelper();
    }

    public static TypeHelper getTypeHelper() {
        return INSTANCE.typeHelper();
    }

    public static XMLHelper getXMLHelper() {
        return INSTANCE.xmlHelper();
    }

    public static XSDHelper getXSDHelper() {
        return INSTANCE.xsdHelper();
    }

    public static ExternalizableDelegator.Resolvable createResolvable() {
        return INSTANCE.resolvable();
    }

    public static ExternalizableDelegator.Resolvable createResolvable(Object target) {
        return INSTANCE.resolvable(target);
    }

    abstract CopyHelper copyHelper();

    abstract DataFactory dataFactory();

    abstract DataHelper dataHelper();

    abstract EqualityHelper equalityHelper();

    abstract TypeHelper typeHelper();

    abstract XMLHelper xmlHelper();

    abstract XSDHelper xsdHelper();

    abstract ExternalizableDelegator.Resolvable resolvable();

    abstract ExternalizableDelegator.Resolvable resolvable(Object var1);

    public static HelperContext getDefaultContext() {
        return INSTANCE.helperContext();
    }

    HelperContext helperContext() {
        return defaultContext;
    }

    static class DefaultHelperContext
    implements HelperContext {
        DefaultHelperContext() {
        }

        public CopyHelper getCopyHelper() {
            return INSTANCE.copyHelper();
        }

        public DataFactory getDataFactory() {
            return INSTANCE.dataFactory();
        }

        public DataHelper getDataHelper() {
            return INSTANCE.dataHelper();
        }

        public EqualityHelper getEqualityHelper() {
            return INSTANCE.equalityHelper();
        }

        public TypeHelper getTypeHelper() {
            return INSTANCE.typeHelper();
        }

        public XMLHelper getXMLHelper() {
            return INSTANCE.xmlHelper();
        }

        public XSDHelper getXSDHelper() {
            return INSTANCE.xsdHelper();
        }
    }
}

