/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class JSplitPaneNoDivider
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private int dividerDragSize = 9;
    private int dividerDragOffset = 4;
    private boolean drawDividerLine = false;

    public JSplitPaneNoDivider() {
        this.setDividerSize(7);
        this.setContinuousLayout(true);
    }

    @Override
    public void layout() {
        super.layout();
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        Rectangle bounds = divider.getBounds();
        if (this.orientation == 1) {
            bounds.x -= this.dividerDragOffset;
            bounds.width = this.dividerDragSize;
        } else {
            bounds.y -= this.dividerDragOffset;
            bounds.height = this.dividerDragSize;
        }
        divider.setBounds(bounds);
    }

    @Override
    public void updateUI() {
        this.setUI(new SplitPaneWithZeroSizeDividerUI());
        this.revalidate();
    }

    public void setDrawDividerLine(boolean drawDividerLine) {
        this.drawDividerLine = drawDividerLine;
    }

    public boolean isDrawDividerLine() {
        return this.drawDividerLine;
    }

    private class SplitPaneWithZeroSizeDividerUI
    extends BasicSplitPaneUI {
        private SplitPaneWithZeroSizeDividerUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new ZeroSizeDivider(this);
        }
    }

    private class ZeroSizeDivider
    extends BasicSplitPaneDivider {
        private static final long serialVersionUID = 1L;

        public ZeroSizeDivider(BasicSplitPaneUI ui) {
            super(ui);
            super.setBorder(null);
            this.setBackground(UIManager.getColor("controlShadow"));
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public void paint(Graphics g2) {
            if (JSplitPaneNoDivider.this.drawDividerLine) {
                g2.setColor(this.getBackground());
                if (this.orientation == 1) {
                    g2.drawLine(JSplitPaneNoDivider.this.dividerDragOffset, 0, JSplitPaneNoDivider.this.dividerDragOffset, this.getHeight() - 1);
                } else {
                    g2.drawLine(0, JSplitPaneNoDivider.this.dividerDragOffset, this.getWidth() - 1, JSplitPaneNoDivider.this.dividerDragOffset);
                }
            }
        }

        @Override
        protected void dragDividerTo(int location) {
            super.dragDividerTo(location + JSplitPaneNoDivider.this.dividerDragOffset);
        }

        @Override
        protected void finishDraggingTo(int location) {
            super.finishDraggingTo(location + JSplitPaneNoDivider.this.dividerDragOffset);
        }
    }
}

