/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.swing.JTextArea;
import net.hironico.common.utils.StringUtils;

public class JTextAreaStreamReader
implements Consumer<Void> {
    private JTextArea txtTarget;
    private Thread displayThread;
    private int maxRows = 5000;

    public JTextAreaStreamReader(InputStream srcInputStream, JTextArea txtTarget) {
        this(srcInputStream, txtTarget, 5000);
    }

    public JTextAreaStreamReader(final InputStream srcInputStream, final JTextArea txtTarget, int maxRows) {
        assert (txtTarget != null);
        assert (srcInputStream != null);
        this.txtTarget = txtTarget;
        this.maxRows = maxRows;
        this.displayThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[0x100000];
                    while (true) {
                        int available = srcInputStream.available();
                        while (available > 0) {
                            int read = srcInputStream.read(buffer, 0, buffer.length);
                            if (JTextAreaStreamReader.this.txtTarget != null) {
                                JTextAreaStreamReader.this.txtTarget.append(new String(buffer, 0, read));
                                JTextAreaStreamReader.this.checkMaxRows();
                            }
                            available = srcInputStream.available();
                        }
                        Thread.sleep(50L);
                    }
                }
                catch (Exception ex) {
                    txtTarget.append("Communication BROKEN.");
                    return;
                }
            }
        });
        this.displayThread.setName("JTextArea display thread");
        this.displayThread.start();
    }

    public void die() throws IOException {
        System.out.println("Stream reader dying ...");
        this.displayThread.interrupt();
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    protected void checkMaxRows() {
        try {
            int rows = StringUtils.countOccurences(this.txtTarget.getText(), '\n');
            while (rows > this.maxRows) {
                String txt = this.txtTarget.getText();
                int index = txt.indexOf("\n");
                if (index < 0) {
                    return;
                }
                this.txtTarget.getDocument().remove(0, index + 1);
                rows = StringUtils.countOccurences(this.txtTarget.getText(), '\n');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void accept(Void v2) {
        try {
            this.die();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

