/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.ribbon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.hironico.common.swing.ribbon.RibbonGroup;

public class RibbonTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RibbonTab.class.getName());
    private String title = "";

    public RibbonTab(String title) {
        this.title = title;
        this.initialize();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void initialize() {
        LOGGER.info("Init ribbon tab : " + this.title);
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 9999;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 2.0;
        Box.Filler filler = new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10));
        this.add((Component)filler, gbc);
    }

    public void addGroup(RibbonGroup groupPanel) {
        int col = this.getComponentCount();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = col;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.fill = 3;
        this.add((Component)groupPanel, gbc);
        JSeparator vertSep = new JSeparator(1);
        ++gbc.gridx;
        this.add((Component)vertSep, gbc);
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int w2 = this.getWidth();
        int h2 = this.getHeight();
        Color color1 = Color.WHITE;
        Color color2 = new Color(229, 233, 238);
        GradientPaint gp = new GradientPaint(0.0f, 0.0f, color1, 0.0f, h2, color2);
        g2d.setPaint(gp);
        g2d.fillRoundRect(0, 0, w2, h2, 15, 15);
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.drawRoundRect(0, 0, w2, h2, 15, 15);
    }
}

